/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoccanvas.macro.AdhocCanvasColumn;
import com.comalatech.confluence.adhoccanvas.macro.AdhocSelectColumnMacro;
import com.comalatech.confluence.checklists.ChecklistManager;
import com.comalatech.confluence.checklists.ValueManager;
import com.comalatech.confluence.checklists.macro.AbstractColumnMacro;
import com.comalatech.confluence.checklists.model.Column;
import com.comalatech.confluence.checklists.model.ColumnType;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdhocCanvasColumn(value=AdhocSelectColumnMacro.class)
public class ChecklistSelectMacro
extends AbstractColumnMacro {
    private static final Logger log = LoggerFactory.getLogger(ChecklistSelectMacro.class);
    private static final String PARAM_USELABELS = "uselabels";
    private static final String PARAM_USERSGROUP = "usersgroup";
    private final ChecklistManager checklistManager;

    public ChecklistSelectMacro(ValueManager valueManager, @ComponentImport PluginAccessor pluginAccessor, ChecklistManager checklistManager) {
        super(valueManager, pluginAccessor);
        this.checklistManager = checklistManager;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    @Override
    public void parseColumnParameters(Page page, Map parameters, String body, Column column) throws MacroException {
        column.setType(7);
        column.setTypeName(ColumnType.SELECT.typeName);
        String struselabels = this.getParameter(page, parameters, PARAM_USELABELS);
        String usersgroup = this.getParameter(page, parameters, PARAM_USERSGROUP);
        column.setUsersGroup(usersgroup);
        boolean useLabels = struselabels != null && struselabels.equalsIgnoreCase("true");
        column.setUseLabels(useLabels);
        column.setUsersList(StringUtils.isNotBlank((CharSequence)usersgroup));
        if (column.isUsersList()) {
            this.addUsersList(column, usersgroup);
        } else {
            this.addOptions(column, body, useLabels);
        }
        column.setUseCheckbox(!column.isUseLabels() && !column.isUsersList() && !column.isStoreInRows() && column.getOptions().size() == 2);
    }

    private void addUsersList(Column column, String usersgroup) throws MacroException {
        try {
            List users = this.checklistManager.getUsers(usersgroup);
            for (Object o : users) {
                User user = (User)o;
                column.addOption(user.getFullName(), "\ud83d\udc64" + user.getName());
            }
        }
        catch (Exception e) {
            throw new MacroException((Throwable)e);
        }
    }

    private void addOptions(Column column, String body, boolean uselabels) throws MacroException {
        if (StringUtils.isNotBlank((CharSequence)body)) {
            StringTokenizer options = new StringTokenizer(body, "\r\n");
            while (options.hasMoreTokens()) {
                String option;
                String id;
                String optionline = options.nextToken().trim();
                if (optionline.length() <= 0) continue;
                int ix = optionline.indexOf("|");
                if (ix > 0) {
                    id = optionline.substring(0, ix).toLowerCase();
                    option = optionline.substring(ix + 1);
                } else {
                    id = optionline.toLowerCase();
                    option = optionline;
                }
                if (uselabels && LabelParser.parse((String)id, (User)AuthenticatedUserThreadLocal.get()) == null) {
                    throw new MacroException("Options to be used to label pages must have ids that do not include " + LabelParser.getInvalidCharactersAsString() + " in column " + column.getHeading());
                }
                column.addOption(option, id);
            }
        }
    }
}

