/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoccanvas.UnsupportedFeatureException;
import com.comalatech.confluence.adhoccanvas.macro.ChecklistXHtmlMacro;
import com.comalatech.confluence.checklists.CellHandler;
import com.comalatech.confluence.checklists.ChecklistManager;
import com.comalatech.confluence.checklists.ValueManager;
import com.comalatech.confluence.checklists.license.ChecklistLicenseManager;
import com.comalatech.confluence.checklists.model.Checklist;
import com.comalatech.confluence.checklists.model.Column;
import com.comalatech.confluence.checklists.model.ColumnType;
import com.comalatech.confluence.checklists.model.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ChecklistMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(ChecklistMacro.class);
    private static final String PARAM_0 = "0";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_PARENT = "parent";
    private static final String PARAM_LABEL = "label";
    private static final String PARAM_SPACE = "space";
    private static final String PARAM_DEPTH = "depth";
    private static final String PARAM_CHILDREN_ONLY = "childrenonly";
    private static final String PARAM_CHECKLABELS = "checklabels";
    private static final String PARAM_COMMENT = "comment-heading";
    private static final String PARAM_EXCERPT = "excerpt-heading";
    private static final String PARAM_SORTTYPE = "sort";
    private static final String PARAM_MUTUALLYEXCLUSIVE = "mutuallyexclusive";
    private static final String PARAM_CLASS = "class";
    private static final String PARAM_PAGEREF = "pagelink";
    private static final String CHECKLIST_KEY = "com.comalatech.checklists";
    public static ThreadLocal<Boolean> reportLimitHitFlag = new ThreadLocal();
    private final ChecklistManager checklistManager;
    private final ValueManager valueManager;
    private final SubRenderer subRenderer;
    private final WikiStyleRenderer wikiStyleRenderer;
    private final PluginAccessor pluginAccessor;
    private final ChecklistLicenseManager licenseManager;
    private final I18nResolver i18nResolver;

    public ChecklistMacro(ChecklistManager checklistManager, ValueManager valueManager, @ComponentImport SubRenderer subRenderer, @ComponentImport WikiStyleRenderer wikiStyleRenderer, @ComponentImport PluginAccessor pluginAccessor, ChecklistLicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver) {
        this.checklistManager = checklistManager;
        this.valueManager = valueManager;
        this.subRenderer = subRenderer;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.pluginAccessor = pluginAccessor;
        this.licenseManager = licenseManager;
        this.i18nResolver = i18nResolver;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    private String getParameter(Page page, Map parameters, String paramName) {
        return this.valueManager.replaceKeywords((ContentEntityObject)page, (String)parameters.get(paramName));
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Checklist checklist;
        ArrayList<Column> columns;
        boolean childrenonly;
        int depth;
        boolean mutuallyexclusive;
        boolean firstTableInPage;
        reportLimitHitFlag.set(false);
        Page page = (Page)((PageContext)renderContext).getEntity();
        if (renderContext.getParam((Object)"com.comalatech.checklists:column-error") != null) {
            return body;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)body) && body.contains("class=\"error\"")) {
            return body;
        }
        boolean bl = firstTableInPage = renderContext.getParam((Object)CHECKLIST_KEY) == null;
        if (firstTableInPage) {
            renderContext.addParam((Object)CHECKLIST_KEY, (Object)"duck");
        }
        String name = this.getParameter(page, parameters, PARAM_NAME);
        String parent = this.getParameter(page, parameters, PARAM_PARENT);
        String label = this.getParameter(page, parameters, PARAM_LABEL);
        String space = this.getParameter(page, parameters, PARAM_SPACE);
        String checklabels = this.getParameter(page, parameters, PARAM_CHECKLABELS);
        String commentHeading = this.getParameter(page, parameters, PARAM_COMMENT);
        String excerptHeading = this.getParameter(page, parameters, PARAM_EXCERPT);
        String strdepth = this.getParameter(page, parameters, PARAM_DEPTH);
        String strchildrenonly = this.getParameter(page, parameters, PARAM_CHILDREN_ONLY);
        String sortKey = this.getParameter(page, parameters, PARAM_SORTTYPE);
        String stylesheetClass = this.getParameter(page, parameters, PARAM_CLASS);
        String pageRef = this.getParameter(page, parameters, PARAM_PAGEREF);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sortKey)) {
            sortKey = PARAM_NAME;
        } else {
            this.checkSortType(sortKey);
        }
        String strmutuallyexclusive = this.getParameter(page, parameters, PARAM_MUTUALLYEXCLUSIVE);
        boolean bl2 = mutuallyexclusive = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)strmutuallyexclusive) && strmutuallyexclusive.equalsIgnoreCase("true");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)strdepth)) {
            try {
                depth = Integer.parseInt(strdepth);
            }
            catch (NumberFormatException e) {
                throw new MacroException("Invalid number format for 'depth'");
            }
        } else {
            depth = 0;
        }
        boolean bl3 = childrenonly = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)strchildrenonly) && strchildrenonly.equals("true");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parent) && !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)label)) {
            parent = page.getTitle();
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)name) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(name = this.getParameter(page, parameters, PARAM_0)))) {
            name = page.getTitle();
        }
        if ((columns = this.removeChecklistColumnList(renderContext)) == null) {
            columns = new ArrayList<Column>();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)checklabels)) {
            this.parseLabels(columns, checklabels, mutuallyexclusive);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)commentHeading)) {
            Column commentColumn = new Column(commentHeading, 6, "40%", stylesheetClass, 'S', false, true);
            commentColumn.setTypeName(ColumnType.COMMENT.typeName);
            commentColumn.setRows(5);
            commentColumn.setCols(50);
            columns.add(commentColumn);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)excerptHeading)) {
            Column excerptColumn = new Column(excerptHeading, 3, "20%", stylesheetClass, 'S', true, true);
            excerptColumn.setTypeName(ColumnType.EXCERPT.typeName);
            columns.add(0, excerptColumn);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pageRef) || Boolean.TRUE.toString().equalsIgnoreCase(pageRef)) {
            Column pageRefColumn = new Column(name, 8, null, null, 'S', false, false);
            pageRefColumn.setTypeName(ColumnType.PAGEREF_DEFAULT.typeName);
            columns.add(0, pageRefColumn);
        }
        if ((checklist = this.checklistManager.createChecklist((SpaceContentEntityObject)page, name, stylesheetClass, sortKey, parent, label, space, depth, childrenonly, columns)).getPages().contains(page)) {
            throw new MacroException("List " + name + " cannot contain the page it belongs to as a row, check the parent filter");
        }
        this.renderChecklist(page, renderContext, checklist);
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("checklist", checklist);
        contextMap.put("checklistHelper", new Helper(firstTableInPage));
        contextMap.put("licenseManager", this.licenseManager);
        contextMap.put("reportLimitHitFlag", reportLimitHitFlag.get());
        contextMap.put("i18nResolver", this.getI18nResolver());
        try {
            return VelocityUtils.getRenderedTemplate((String)"templates/checklist.vm", (Map)contextMap);
        }
        catch (Exception e) {
            throw new MacroException((Throwable)e);
        }
    }

    private List removeChecklistColumnList(RenderContext renderContext) {
        return (List)renderContext.getParams().remove("com.comalatech.checklists:columns");
    }

    protected boolean isAdhocCanvasInstalled() {
        return this.pluginAccessor.isPluginEnabled("com.comalatech.adhoccanvas");
    }

    private boolean isDebug(Map<String, String> parameters) {
        return "true".equalsIgnoreCase(parameters.get("debug"));
    }

    private boolean isUseCanvas(Map<String, String> parameters) {
        return Boolean.parseBoolean(parameters.get("usecanvas"));
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        try {
            Object canvasList = "";
            if (this.isAdhocCanvasInstalled() && this.isUseCanvas(parameters)) {
                ChecklistXHtmlMacro newMacro = new ChecklistXHtmlMacro(this.valueManager, this.wikiStyleRenderer);
                try {
                    canvasList = newMacro.execute(parameters, body, context);
                    if (!this.isDebug(parameters)) {
                        this.removeChecklistColumnList((RenderContext)context.getPageContext());
                        return canvasList;
                    }
                }
                catch (UnsupportedFeatureException e) {
                    newMacro.removeAdhocCanvasColumnList(context);
                    canvasList = "<div class='error'>" + e.getMessage() + "</div>";
                }
            }
            if (context.getEntity() instanceof Draft) {
                try {
                    Map contextMap = MacroUtils.defaultVelocityContext();
                    contextMap.put("i18nResolver", this.i18nResolver);
                    canvasList = VelocityUtils.getRenderedTemplate((String)"templates/previewErrorMsg.vm", (Map)contextMap);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                canvasList = (String)canvasList + this.execute(parameters, body, (RenderContext)context.getPageContext());
            }
            return canvasList;
        }
        catch (MacroException e) {
            throw new MacroExecutionException(e.getMessage());
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public void renderChecklist(Page checklistPage, RenderContext renderContext, Checklist checklist) throws MacroException {
        for (Row row : checklist.getRows()) {
            row.setRenderedPageLink(this.renderPageLink(row.getPage(), renderContext));
            for (Column column : checklist.getColumns()) {
                CellHandler cellHandler = column.getCellHandler();
                Object rowContext = renderContext instanceof PageContext ? new PageContext((ContentEntityObject)row.getPage(), (PageContext)renderContext) : renderContext;
                try {
                    cellHandler.makeCell(checklist, row, column, this.subRenderer, (RenderContext)rowContext);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new MacroException((Throwable)e);
                }
            }
        }
    }

    private String renderPageLink(Page page, RenderContext renderContext) {
        String wikiLink = "[" + page.getTitle() + "|" + page.getSpace().getKey() + ":" + page.getTitle() + "]";
        return this.subRenderer.render(wikiLink, renderContext, RenderMode.allow((long)8L));
    }

    /*
     * WARNING - void declaration
     */
    private List parseLabels(List columns, String labels, boolean mutuallyexclusive) throws MacroException {
        void var8_10;
        String[] labelNames = StringUtils.commaDelimitedListToStringArray((String)labels);
        ArrayList<Column> parsedlabels = new ArrayList<Column>();
        String[] stringArray = labelNames;
        int n = stringArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            String labelName = stringArray[var8_10];
            Column column = new Column(labelName.trim(), 1, null, null, 'S', false, true);
            String label = labelName.trim();
            if (LabelParser.parse((String)label, (User)AuthenticatedUserThreadLocal.get()) == null) {
                throw new MacroException("labels cannot contain " + LabelParser.getInvalidCharactersAsString());
            }
            column.setLabel(label);
            parsedlabels.add(column);
            ++var8_10;
        }
        if (parsedlabels.size() > 1 && mutuallyexclusive) {
            Column selectColumn = new Column("Label", 7, null, null, 'S', false, true);
            selectColumn.setUseLabels(true);
            for (Object e : parsedlabels) {
                Column label = (Column)e;
                selectColumn.addOption(label.getHeading(), label.getLabel().getName());
            }
            columns.add(selectColumn);
        } else {
            columns.addAll(parsedlabels);
        }
        return columns;
    }

    public void checkSortType(String sortType) throws MacroException {
        for (int i = 0; i < Checklist.SORT_TYPES.length; ++i) {
            if (!Checklist.SORT_TYPES[i].equals(sortType)) continue;
            return;
        }
        throw new MacroException("Invalid sort type " + sortType + " it should be any of " + StringUtils.arrayToCommaDelimitedString((Object[])Checklist.SORT_TYPES));
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    public static class Helper {
        boolean loadScripts;

        public Helper(boolean loadScripts) {
            this.loadScripts = loadScripts;
        }

        public boolean isLoadScripts() {
            try {
                boolean bl = this.loadScripts;
                return bl;
            }
            finally {
                this.loadScripts = false;
            }
        }
    }
}

