/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.utils.MetadataSerializer;
import org.springframework.stereotype.Component;

@Component
public class ValueManager {
    private final String SEPARATOR = "@";
    private final MetadataSerializer metadataSerializer;

    public ValueManager(MetadataSerializer metadataSerializer) {
        this.metadataSerializer = metadataSerializer;
    }

    public String replaceKeywords(ContentEntityObject ceo, String valueNameWithKeywords) {
        int nextix;
        if (valueNameWithKeywords == null) {
            return null;
        }
        int ix = valueNameWithKeywords.indexOf("@");
        if (ix < 0) {
            return valueNameWithKeywords;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        do {
            sb.append(valueNameWithKeywords.substring(start, ix));
            if (ix + 1 >= valueNameWithKeywords.length()) {
                start = ix + 1;
                break;
            }
            nextix = valueNameWithKeywords.indexOf("@", ix + 1);
            if (nextix < 0) {
                nextix = valueNameWithKeywords.length();
            }
            String keyword = valueNameWithKeywords.substring(ix + 1, nextix);
            sb.append(this.getKeywordValue(ceo, keyword));
        } while ((ix = (start = nextix + 1) < valueNameWithKeywords.length() ? valueNameWithKeywords.indexOf("@", start) : -1) > 0);
        if (start < valueNameWithKeywords.length()) {
            sb.append(valueNameWithKeywords.substring(start));
        }
        return sb.toString();
    }

    private String getKeywordValue(ContentEntityObject ceo, String keyword) {
        if (keyword.equalsIgnoreCase("user")) {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            if (user == null) {
                return "anonymous";
            }
            return user.getName();
        }
        if (keyword.equalsIgnoreCase("userfullname")) {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            if (user == null) {
                return "anonymous";
            }
            return user.getFullName();
        }
        if (keyword.equalsIgnoreCase("self") || keyword.equalsIgnoreCase("title")) {
            return ceo.getTitle();
        }
        if (keyword.equalsIgnoreCase("creator")) {
            return ceo.getCreator().getName();
        }
        if (keyword.equalsIgnoreCase("modifier")) {
            return ceo.getLastModifier().getName();
        }
        String value = this.metadataSerializer.getMetadataValue(ceo, keyword);
        return value != null ? value : "";
    }
}

