/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.comalatech.confluence.checklists.MetadataCellHandler;
import com.comalatech.confluence.checklists.model.Column;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SelectCellHandler
extends MetadataCellHandler {
    @Override
    public RenderMode getRenderMode() {
        return null;
    }

    @Override
    public String getTemplate(Column column) {
        if (column.isUseCheckbox()) {
            return "templates/checkboxcell.vm";
        }
        return "templates/selectcell.vm";
    }

    @Override
    public void setValue(SpaceContentEntityObject entity, Page page, Column column, String value) {
        if (StringUtils.isNotBlank((CharSequence)column.getOptionIds())) {
            this.changeLabel(page, value, column.getOptionIds());
        } else {
            super.setValue(entity, page, column, value);
        }
    }

    @Override
    public String renderValue(SubRenderer subRenderer, RenderContext renderContext, Column column, String value) {
        if (column.isUsersList() && StringUtils.isNotBlank((CharSequence)value)) {
            return subRenderer.render("\ud83d\udc64" + value, renderContext, RenderMode.allow((long)8L));
        }
        return super.renderValue(subRenderer, renderContext, column, value);
    }

    @Override
    public String getValue(SpaceContentEntityObject entity, Page page, Column column) {
        if (column.isUseCheckbox()) {
            String value = super.getValue(entity, page, column);
            value = StringUtils.isNotBlank((CharSequence)value) && value.equalsIgnoreCase(column.getOptionIds()) ? "true" : "false";
            return value;
        }
        if (StringUtils.isNotBlank((CharSequence)column.getOptionIds())) {
            return this.getSelectedLabel(page, column);
        }
        return super.getValue(entity, page, column);
    }

    @Override
    public Map makeContextMap() {
        Map map = super.makeContextMap();
        map.put("checkboxMethod", "changeCheckbox");
        return map;
    }

    private String getSelectedLabel(Page page, Column column) {
        Label[] labels = this.parseLabelList(column.getOptionIds());
        Label selected = this.getChecklistManager().getSelectedLabel(page, labels);
        if (selected == null) {
            return null;
        }
        return selected.getName().replaceAll("\\[\\~(\\w+)\\]", "\ud83d\udc64$1");
    }

    private void changeLabel(Page page, String newLabel, String idsList) {
        Label[] labels = this.parseLabelList(idsList);
        this.getChecklistManager().swapLabel(page, new Label(newLabel), labels);
    }

    protected Label[] parseLabelList(String idsList) {
        String search = "\ud83d\udc64(\\w+)";
        List<String> labelNames = Arrays.asList(idsList.split("\\|"));
        ArrayList<Label> labels = new ArrayList<Label>();
        for (String labelName : labelNames) {
            labels.add(new Label(labelName));
            if (!labelName.matches(search)) continue;
            labels.add(new Label(labelName.replaceAll(search, "[~$1]")));
        }
        return labels.toArray(new Label[labels.size()]);
    }
}

