/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.comalatech.confluence.checklists.CellHandler;
import com.comalatech.confluence.checklists.model.Column;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcerptCellHandler
extends CellHandler {
    private static final Logger log = LoggerFactory.getLogger(ExcerptCellHandler.class);

    @Override
    public String getValue(SpaceContentEntityObject entity, Page page, Column column) {
        return this.getChecklistManager().getPageExcerpt(page);
    }

    @Override
    public void setValue(SpaceContentEntityObject entity, Page page, Column column, String value) {
    }

    @Override
    public RenderMode getRenderMode() {
        return RenderMode.INLINE;
    }

    @Override
    public String renderValue(SubRenderer subRenderer, RenderContext renderContext, Column column, String value) {
        XhtmlContent xhtmlContent = this.getXhtmlContent();
        String renderedValue = "";
        try {
            renderedValue = xhtmlContent.convertStorageToView(value, (ConversionContext)new DefaultConversionContext(renderContext));
        }
        catch (XhtmlException | XMLStreamException e) {
            log.error("", e);
            renderedValue = "Error rendering excerpt";
        }
        return "<span class=\"smalltext\">" + renderedValue + "</span>";
    }

    @Override
    public String getTemplate(Column column) {
        return null;
    }
}

