/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoccanvas.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.comalatech.confluence.adhoccanvas.model.AdhocColumn;
import com.comalatech.confluence.checklists.ValueManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractXhtmlMacro
implements Macro {
    public static final String ADHOCCOLUMNS_KEY = "com.comalatech.adhoccanvas:columns";
    private final ValueManager valueManager;

    protected AbstractXhtmlMacro(ValueManager valueManager) {
        this.valueManager = valueManager;
    }

    protected String[] split(String string) {
        if (string == null) {
            return new String[0];
        }
        return string.replaceAll(" ", "").split(",");
    }

    protected List<AdhocColumn> getAdhocColumsList(ConversionContext conversionContext) {
        ArrayList list = (ArrayList)conversionContext.getProperty(ADHOCCOLUMNS_KEY);
        if (list == null) {
            list = new ArrayList();
            conversionContext.setProperty(ADHOCCOLUMNS_KEY, list);
        }
        return list;
    }

    public List<AdhocColumn> removeAdhocCanvasColumnList(ConversionContext conversionContext) {
        List<AdhocColumn> list = this.getAdhocColumsList(conversionContext);
        conversionContext.removeProperty(ADHOCCOLUMNS_KEY);
        return list;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public abstract class MacroParameters {
        private final Map<String, String> params;
        private ConversionContext conversionContext;

        MacroParameters(Map<String, String> params, ConversionContext conversionContext) throws MacroExecutionException {
            this.params = params;
            this.conversionContext = conversionContext;
        }

        ContentEntityObject getEntity() {
            return this.conversionContext.getEntity();
        }

        String get(String ... keys) {
            for (String key : keys) {
                String value = AbstractXhtmlMacro.this.valueManager.replaceKeywords(this.conversionContext.getEntity(), this.params.get(key));
                if (value == null) continue;
                return value;
            }
            return null;
        }

        String getMandatory(String ... keys) throws MacroExecutionException {
            String value = this.get(keys);
            if (value == null) {
                throw new MacroExecutionException("Parameter '" + keys[0] + "' expected");
            }
            return value;
        }

        boolean getFlag(String ... keys) {
            String val = this.get(keys);
            return this.flagValue(val);
        }

        private boolean flagValue(String val) {
            return "true".equalsIgnoreCase(val) || "yes".equals(val) || "enabled".equalsIgnoreCase(val);
        }

        boolean getFlag(boolean defaultValue, String ... keys) {
            String val = this.get(keys);
            if (val == null) {
                return defaultValue;
            }
            return this.flagValue(val);
        }

        int getInt(String ... keys) throws MacroExecutionException {
            try {
                return Integer.parseInt(this.get(keys));
            }
            catch (Exception e) {
                throw new MacroExecutionException("Invalid integer value " + this.get(keys));
            }
        }

        int getInt(int defaultValue, String ... keys) {
            try {
                return this.getInt(keys);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
    }
}

