/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.checklists.ChecklistManager;
import com.comalatech.confluence.checklists.license.ChecklistLicenseManager;
import com.comalatech.confluence.checklists.model.Column;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecklistAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(ChecklistAction.class);
    private long pageId;
    private long entityId;
    private String columnKey;
    private String width;
    private String value;
    private String renderedValueHtml;
    private String cellId;
    private String checklistId;
    private String optionIds;
    private int rows;
    private int cols;
    private String columnType;
    private Column column;
    private Page page;
    private Page checklistPage;
    private boolean storeInRows;
    private ChecklistManager checklistManager;
    private ChecklistLicenseManager licenseManager;

    @ReadOnlyAccessBlocked
    public String changeLabel() {
        this.column = new Column(this.columnKey, 1, null, null, 'S', false, true);
        this.column.setLabel(this.columnKey);
        this.setValue();
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String changeCheckbox() {
        this.column = new Column(this.columnKey, 7, null, null, 'S', false, false);
        this.setValue();
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String changeSelect() {
        this.column = new Column(this.columnKey, 7, null, null, 'S', false, this.storeInRows);
        this.column.setOptionIds(this.optionIds);
        this.setValue();
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String changeInput() {
        this.column = new Column(this.columnKey, 2, null, null, 'S', false, this.storeInRows);
        this.setValue();
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String setWikiInput() {
        this.column = new Column(this.columnKey, 6, null, null, 'S', false, this.storeInRows);
        this.column.setRows(this.rows);
        this.column.setCols(this.cols);
        if (!this.setValue()) {
            this.value = this.column.getCellHandler().getValue(null, this.page, this.column);
        }
        this.renderedValueHtml = this.checklistManager.renderWiki(this.page, this.value);
        return "success";
    }

    public String editWiki() {
        this.column = new Column(this.columnKey, 6, null, null, 'S', false, this.storeInRows);
        this.column.setRows(this.rows);
        this.column.setCols(this.cols);
        if (this.getPage() != null && this.getChecklistPage() != null) {
            this.value = this.column.getCellHandler().getValue((SpaceContentEntityObject)this.checklistPage, this.page, this.column);
        }
        return "success";
    }

    public String getSortValue() {
        int type = Column.parseType(this.columnType);
        if (type == 0) {
            return "";
        }
        this.column = new Column(this.columnKey, type, null, null, 'S', false, this.storeInRows);
        this.column.setOptionIds(this.optionIds);
        this.value = this.column.getCellHandler().getValue((SpaceContentEntityObject)this.getChecklistPage(), this.getPage(), this.column);
        this.value = this.column.getCellHandler().makeSortValue(this.value);
        return "success";
    }

    private boolean setValue() {
        if (this.getPage() == null || this.getChecklistPage() == null) {
            return false;
        }
        if (this.licenseManager.isDevelopmentMode() && !this.value.isEmpty() && this.value.charAt(0) == '\u00f0') {
            try {
                this.value = new String(this.value.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                log.error("Error encoding string: " + this.value, (Throwable)e);
            }
        }
        this.column.getCellHandler().setValue((SpaceContentEntityObject)this.checklistPage, this.page, this.column, this.value);
        return true;
    }

    @ParameterSafe
    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    public Page getPage() {
        if (this.page == null) {
            this.page = this.checklistManager.getPageAndLogNotFound(this.pageId);
        }
        return this.page;
    }

    public Page getChecklistPage() {
        if (this.checklistPage == null) {
            this.checklistPage = this.checklistManager.getPageAndLogNotFound(this.entityId);
        }
        return this.checklistPage;
    }

    @ParameterSafe
    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    @ParameterSafe
    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    @ParameterSafe
    public void setValue(String value) {
        this.value = value;
    }

    @ParameterSafe
    public void setStoreInRows(boolean storeInRows) {
        this.storeInRows = storeInRows;
    }

    @HtmlSafe
    public String getRenderedValueHtml() {
        return this.renderedValueHtml;
    }

    @ParameterSafe
    public void setRenderedValueHtml(String renderedValueHtml) {
        this.renderedValueHtml = renderedValueHtml;
    }

    @ParameterSafe
    public void setCellId(String cellId) {
        this.cellId = cellId;
    }

    @ParameterSafe
    public void setChecklistId(String checklistId) {
        this.checklistId = checklistId;
    }

    @ParameterSafe
    public void setRows(int rows) {
        this.rows = rows;
    }

    @ParameterSafe
    public int getCols() {
        return this.cols;
    }

    @ParameterSafe
    public void setCols(int cols) {
        this.cols = cols;
    }

    @ParameterSafe
    public void setWidth(String width) {
        this.width = width;
    }

    @ParameterSafe
    public void setColumnKey(String columnKey) {
        this.columnKey = columnKey;
    }

    @ParameterSafe
    public void setColumn(Column column) {
        this.column = column;
    }

    @ParameterSafe
    public void setOptionIds(String optionIds) {
        this.optionIds = optionIds;
    }

    public String getUnrenderedValue() {
        return this.value;
    }

    public long getPageId() {
        return this.pageId;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public String getColumnKey() {
        return this.columnKey;
    }

    public String getWidth() {
        return this.width;
    }

    public String getValue() {
        return this.value;
    }

    public String getCellId() {
        return this.cellId;
    }

    public String getChecklistId() {
        return this.checklistId;
    }

    public String getOptionIds() {
        return this.optionIds;
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean isStoreInRows() {
        return this.storeInRows;
    }

    public void setChecklistManager(ChecklistManager checklistManager) {
        this.checklistManager = checklistManager;
    }

    public void setLicenseManager(ChecklistLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }
}

