/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.comalatech.confluence.checklists.CellHandler;
import com.comalatech.confluence.checklists.model.Column;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.web.util.HtmlUtils;

public class PageRefCellHandler
extends CellHandler {
    @Override
    public String getValue(SpaceContentEntityObject entity, Page page, Column column) {
        return page.getIdAsString();
    }

    @Override
    public String makeSortValue(String value) {
        Page page = this.getChecklistManager().getPageAndLogNotFound(NumberUtils.createLong((String)value));
        if (page != null) {
            String escapedPageTitle = HtmlUtils.htmlEscape((String)page.getTitle());
            return super.makeSortValue(escapedPageTitle);
        }
        return "";
    }

    @Override
    public void setValue(SpaceContentEntityObject entity, Page page, Column column, String value) {
    }

    @Override
    public RenderMode getRenderMode() {
        return RenderMode.INLINE;
    }

    @Override
    public String renderValue(SubRenderer subRenderer, RenderContext renderContext, Column column, String value) {
        Page page = this.getChecklistManager().getPageAndLogNotFound(NumberUtils.createLong((String)value));
        if (page != null) {
            String escapedPageTitle = HtmlUtils.htmlEscape((String)page.getTitle());
            if (column.isEditLink()) {
                return "<a href=\"" + renderContext.getSiteRoot() + "/pages/editpage.action?pageId=" + page.getIdAsString() + "\">" + escapedPageTitle + "</a>";
            }
            return "<a href=\"" + renderContext.getSiteRoot() + page.getUrlPath() + "\">" + escapedPageTitle + "</a>";
        }
        return "cannot get " + value;
    }

    @Override
    public String getTemplate(Column column) {
        return null;
    }
}

