/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.ExcerptHelper;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.search.page.Pager;
import com.comalatech.confluence.changelog.ChangeLogManager;
import com.comalatech.confluence.checklists.CellHandler;
import com.comalatech.confluence.checklists.content.ComalaPropertiesSetManager;
import com.comalatech.confluence.checklists.macro.ChecklistMacro;
import com.comalatech.confluence.checklists.model.Checklist;
import com.comalatech.confluence.checklists.model.Column;
import com.comalatech.confluence.checklists.model.Row;
import com.comalatech.confluence.utils.ChecklistUtils;
import com.comalatech.confluence.utils.MetadataSerializer;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ChecklistManager
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ChecklistManager.class);
    public static final int MAX_USERS = 60;
    private static final String KEY_PREFIX = "com.comalatech.checklist-attribute:";
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final LabelManager labelManager;
    private final ChangeLogManager changeLogManager;
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final WikiStyleRenderer wikiStyleRenderer;
    private final MetadataSerializer metadataSerializer;
    private final Renderer viewRenderer;
    private final XhtmlContent xhtmlContent;
    private final AccessModeService accessModeService;
    private final CQLSearchService cqlSearchService;
    private ExcerptHelper excerptHelper;

    public ChecklistManager(PageManager pageManager, PermissionManager permissionManager, LabelManager labelManager, ChangeLogManager changeLogManager, ComalaPropertiesSetManager contentPropertyManager, UserManager userManager, GroupManager groupManager, WikiStyleRenderer wikiStyleRenderer, MetadataSerializer metadataSerializer, Renderer viewRenderer, XhtmlContent xhtmlContent, AccessModeService accessModeService, CQLSearchService cqlSearchService) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.labelManager = labelManager;
        Column.setLabelManager(labelManager);
        this.changeLogManager = changeLogManager;
        this.contentPropertyManager = contentPropertyManager;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.metadataSerializer = metadataSerializer;
        this.viewRenderer = viewRenderer;
        this.xhtmlContent = xhtmlContent;
        CellHandler.setXhtmlContent(xhtmlContent);
        this.accessModeService = accessModeService;
        this.cqlSearchService = cqlSearchService;
        CellHandler.setChecklistManager(this);
    }

    public Checklist createChecklist(SpaceContentEntityObject entity, String name, String stylesheetClass, String sortKey, String parentTitle, String labelName, String querySpaceKey, int depth, boolean childrenOnly, List columns) {
        String targetedSpaceKey = StringUtils.isNotBlank((CharSequence)querySpaceKey) ? querySpaceKey : entity.getSpaceKey();
        Page parent = this.getPageByTitleAndSpace(targetedSpaceKey, parentTitle);
        List<Page> pages = this.getChecklistPages(parent, labelName, depth, childrenOnly, targetedSpaceKey);
        Checklist checklist = new Checklist(entity, name, sortKey, stylesheetClass, pages, columns);
        checklist = this.setAccessPermissions(checklist);
        return checklist;
    }

    private List<Page> getChecklistPages(Page parent, String labelName, int depth, boolean childrenOnly, String targetedSpaceKey) {
        Label label = this.getLabel(labelName);
        List<Page> pages = parent != null ? this.getChildrenPages(parent, label, depth, childrenOnly) : this.getSpacePages(targetedSpaceKey, label);
        return pages;
    }

    private Label getLabel(String labelName) {
        Label label = null;
        if (StringUtils.isNotBlank((CharSequence)labelName) && (label = this.labelManager.getLabel(labelName)) == null) {
            label = new Label(labelName);
        }
        return label;
    }

    private List<Page> removeContentsThatAreNotActivePages(List<Labelable> contentList) {
        ArrayList<Page> pages = new ArrayList<Page>();
        for (Labelable labelableItem : contentList) {
            if (!(labelableItem instanceof Page) || !((Page)labelableItem).isCurrent()) continue;
            pages.add((Page)labelableItem);
        }
        return pages;
    }

    private Checklist setAccessPermissions(Checklist checklist) {
        Iterator<Row> i = checklist.getRows().iterator();
        while (i.hasNext()) {
            Row row = i.next();
            if (this.canView((SpaceContentEntityObject)row.getPage())) {
                if (this.canEdit((SpaceContentEntityObject)row.getPage())) continue;
                row.setReadOnly(true);
                continue;
            }
            i.remove();
        }
        return checklist;
    }

    public boolean canEdit(final SpaceContentEntityObject entity) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ChecklistManager.this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)entity);
            }
        });
    }

    private boolean canView(SpaceContentEntityObject entity) {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)entity);
    }

    private boolean checkEditPermissionAndLogViolation(SpaceContentEntityObject entity) {
        if (this.canEdit(entity)) {
            return true;
        }
        log.error(AuthenticatedUserThreadLocal.get() + " cannot modify " + entity);
        return false;
    }

    private boolean checkViewPermissionAndLogViolation(SpaceContentEntityObject entity) {
        if (this.canView(entity)) {
            return true;
        }
        log.error(AuthenticatedUserThreadLocal.get() + " cannot view " + entity);
        return false;
    }

    private List<Page> getSpacePages(String targetedSpaceKey, @Nullable Label label) {
        PageResponse pageResponse;
        if (log.isDebugEnabled()) {
            log.debug("Space: " + targetedSpaceKey + " label:" + (label != null ? label.getName() : "null"));
        }
        ArrayList<Page> pages = new ArrayList<Page>();
        ArrayList pagesIds = new ArrayList();
        StringBuilder cqlQuery = new StringBuilder("type = page AND space = \"" + targetedSpaceKey + "\"");
        if (label != null) {
            cqlQuery.append(" AND label = \"" + label.getName() + "\"");
        }
        int startPaginationFrom = 0;
        do {
            pageResponse = this.cqlSearchService.searchContent(cqlQuery.toString(), (PageRequest)new SimplePageRequest(startPaginationFrom, 500), new Expansion[0]);
            HashSet<Long> contentIds = new HashSet<Long>();
            for (Content content : pageResponse.getResults()) {
                contentIds.add(content.getId().asLong());
            }
            contentIds.removeAll(pagesIds);
            pages.addAll(this.pageManager.getPages(contentIds));
            pagesIds.addAll(contentIds);
            startPaginationFrom += pageResponse.size();
        } while (pageResponse.hasMore() && pages.size() < ChecklistUtils.getSystemMaxPageResults());
        if (pages.size() == ChecklistUtils.getSystemMaxPageResults()) {
            ChecklistMacro.reportLimitHitFlag.set(true);
        }
        return pages;
    }

    private List<Page> getChildrenPages(Page parent, @Nullable Label label, int depth, boolean childrenOnly) {
        if (log.isDebugEnabled()) {
            log.debug("Parent: " + parent.getDisplayTitle() + " label:" + (label != null ? label.getName() : "null") + " depth:" + depth);
        }
        ArrayList<Page> pages = new ArrayList<Page>();
        ArrayList pagesIds = new ArrayList();
        StringBuilder cqlQuery = new StringBuilder("type = page AND ancestor = \"" + parent.getIdAsString() + "\"");
        if (label != null) {
            cqlQuery.append(" AND label = \"" + label.getName() + "\"");
        }
        PageResponse pageResponse = null;
        int startPaginationFrom = 0;
        do {
            HashSet<Long> contentIds = new HashSet<Long>();
            if (depth >= 1 || childrenOnly) {
                pageResponse = this.cqlSearchService.searchContent(cqlQuery.toString(), (PageRequest)new SimplePageRequest(startPaginationFrom, 500), new Expansion[]{new Expansion("ancestors")});
                depth = childrenOnly ? 1 : depth;
                int effectiveDepth = parent.getAncestors() != null ? depth + parent.getAncestors().size() : depth;
                for (Content content : pageResponse.getResults()) {
                    if (effectiveDepth < content.getAncestors().size()) continue;
                    contentIds.add(content.getId().asLong());
                }
            } else if (depth == 0) {
                pageResponse = this.cqlSearchService.searchContent(cqlQuery.toString(), (PageRequest)new SimplePageRequest(startPaginationFrom, 500), new Expansion[0]);
                for (Content content : pageResponse.getResults()) {
                    contentIds.add(content.getId().asLong());
                }
            }
            contentIds.removeAll(pagesIds);
            pages.addAll(this.pageManager.getPages(contentIds));
            pagesIds.addAll(contentIds);
            startPaginationFrom += pageResponse.size();
        } while (pageResponse != null && pageResponse.hasMore() && pages.size() < ChecklistUtils.getSystemMaxPageResults());
        if (pages.size() == ChecklistUtils.getSystemMaxPageResults()) {
            ChecklistMacro.reportLimitHitFlag.set(true);
        }
        return pages;
    }

    public Page getPageAndLogNotFound(long pageId) {
        Page page = this.pageManager.getPage(pageId);
        if (page == null) {
            log.error("Page " + pageId + " does not exist");
            return null;
        }
        return page;
    }

    public void addLabel(Page page, Label label) {
        if (!this.checkEditPermissionAndLogViolation((SpaceContentEntityObject)page)) {
            return;
        }
        this.labelManager.addLabel((Labelable)page, label);
        this.changeLogManager.logLabelChange((ContentEntityObject)page, label.getName(), true);
    }

    public void removeLabel(Page page, Label label) {
        if (!this.checkEditPermissionAndLogViolation((SpaceContentEntityObject)page)) {
            return;
        }
        this.labelManager.removeLabel((Labelable)page, label);
        this.changeLogManager.logLabelChange((ContentEntityObject)page, label.getName(), false);
    }

    public Label getSelectedLabel(Page page, Label[] labels) {
        List pageLabels = page.getLabels();
        for (int i = 0; i < labels.length; ++i) {
            if (!pageLabels.contains(labels[i])) continue;
            return labels[i];
        }
        return null;
    }

    public void swapLabel(Page page, Label newLabel, Label[] labels) {
        List pageLabels = page.getLabels();
        for (int i = 0; i < labels.length; ++i) {
            Label label = labels[i];
            if (!pageLabels.contains(label) || label == newLabel) continue;
            this.removeLabel(page, label);
        }
        if (StringUtils.isNotBlank((CharSequence)newLabel.toString()) && !pageLabels.contains(newLabel)) {
            this.addLabel(page, newLabel);
        }
    }

    public String getValue(Page page, String columnKey) {
        if (!this.checkViewPermissionAndLogViolation((SpaceContentEntityObject)page)) {
            return "";
        }
        String value = this.metadataSerializer.getMetadataValue((ContentEntityObject)page, columnKey);
        if (!TextUtils.stringSet((String)value)) {
            return this.getValueV1_0AndSetAsMetadata(page, columnKey);
        }
        return value;
    }

    public void setValue(Page page, String columnKey, String value) {
        if (this.checkEditPermissionAndLogViolation((SpaceContentEntityObject)page)) {
            String oldValue = this.metadataSerializer.getMetadataValue((ContentEntityObject)page, columnKey);
            this.changeLogManager.logChange((ContentEntityObject)page, columnKey, oldValue, value);
            this.metadataSerializer.setMetadataValue((ContentEntityObject)page, columnKey, value);
        }
    }

    public void setValueNoLog(Page page, String columnKey, String value) {
        if (this.checkEditPermissionAndLogViolation((SpaceContentEntityObject)page)) {
            this.metadataSerializer.setMetadataValue((ContentEntityObject)page, columnKey, value);
        }
    }

    public String renderWiki(Page page, String wiki) {
        PageContext pageContext = page.toPageContext();
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, wiki);
    }

    private String getValueV1_0AndSetAsMetadata(Page page, String columnKey) {
        String attributeName = StringUtils.replace((String)columnKey, (String)" ", (String)"");
        String key = this.makeKey(ChecklistManager.makeId(attributeName));
        String text = this.contentPropertyManager.getTextProperty((ContentEntityObject)page, key);
        if (TextUtils.stringSet((String)text)) {
            log.info("will convert to use metadata " + key + " to " + columnKey + " on page " + page);
            this.setValue(page, columnKey, text);
            this.contentPropertyManager.setTextProperty((ContentEntityObject)page, key, "");
        }
        return text;
    }

    public static String makeId(String str) {
        char[] chars = str.toCharArray();
        StringBuffer id = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < chars.length; ++i) {
            if (first) {
                if (!Character.isLetter(chars[i])) continue;
                id.append(chars[i]);
                first = false;
                continue;
            }
            if (!Character.isLetterOrDigit(chars[i])) continue;
            id.append(chars[i]);
        }
        if (id.length() == 0) {
            id.append("id").append(str.hashCode());
        }
        return id.toString();
    }

    private String makeKey(String id) {
        return KEY_PREFIX + id;
    }

    public Page getPageByTitleAndSpace(String contextSpaceKey, String unparsedPageTitle) {
        int ix;
        if (unparsedPageTitle == null) {
            return null;
        }
        Page page = this.pageManager.getPage(contextSpaceKey, unparsedPageTitle);
        if (page == null && (ix = unparsedPageTitle.indexOf(":")) > 0) {
            String spaceKey = unparsedPageTitle.substring(0, ix);
            String pageTitle = unparsedPageTitle.substring(ix + 1);
            page = this.pageManager.getPage(spaceKey, pageTitle);
        }
        return page;
    }

    public String getPageExcerpt(Page page) {
        if (!this.checkViewPermissionAndLogViolation((SpaceContentEntityObject)page)) {
            return "";
        }
        return this.excerptHelper.getExcerpt((ContentEntityObject)page);
    }

    public String getRenderedPageContent(Page page) {
        if (!this.checkViewPermissionAndLogViolation((SpaceContentEntityObject)page)) {
            return "";
        }
        BodyContent content = page.getBodyContent();
        PageContext renderContext = page.toPageContext();
        if (content.getBodyType().equals((Object)BodyType.XHTML)) {
            DefaultConversionContext context = new DefaultConversionContext((RenderContext)renderContext);
            return this.viewRenderer.render((ContentEntityObject)page, (ConversionContext)context);
        }
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)renderContext, content.getBody());
    }

    public List getUsers(String groupName) throws Exception {
        Pager pager;
        ArrayList<User> users = new ArrayList<User>();
        if (groupName == null) {
            pager = this.userManager.getUserNames();
        } else {
            Group group = this.groupManager.getGroup(groupName);
            if (groupName.equalsIgnoreCase("all")) {
                pager = group == null ? this.userManager.getUserNames() : this.groupManager.getMemberNames(group);
            } else if (group != null) {
                pager = this.groupManager.getMemberNames(group);
            } else {
                throw new Exception("group " + groupName + " does not exist");
            }
            if (pager == null) {
                throw new Exception("could not retrieve users for group " + groupName + " because of issues in confluence handling externally managed groups. see CHK-15");
            }
        }
        int n = 0;
        while (pager.getCurrentPage().size() > 0) {
            if (n + pager.getCurrentPage().size() > 60) {
                throw new Exception("users list for selection cannot be more than 60 try a more restrictive group");
            }
            Iterator i = pager.getCurrentPage().iterator();
            while (i.hasNext()) {
                users.add(this.userManager.getUser((String)i.next()));
            }
            if (pager.onLastPage()) break;
            pager.nextPage();
        }
        return users;
    }

    public void afterPropertiesSet() throws Exception {
        this.excerptHelper = (ExcerptHelper)ContainerManager.getComponent((String)"excerptHelper");
    }
}

