/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.model;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.checklists.ChecklistManager;
import com.comalatech.confluence.checklists.model.Column;
import com.comalatech.confluence.checklists.model.Row;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Checklist {
    public static final int MAX_SORT_VALUE_LENGTH = 20;
    public static final String SORT_NAME = "name";
    public static final String SORT_CREATED = "created";
    public static final String SORT_MODIFIED = "modified";
    public static final String[] SORT_TYPES = new String[]{"name", "created", "modified"};
    private static final String DEFAULT_STYLESHEET_CLASS = "grid";
    private List<Row> rows;
    private SpaceContentEntityObject entity;
    private String name;
    private List<Page> pages;
    private List<Column> columns;
    private String id;
    private char sortType;
    private String stylesheetClass;

    public Checklist(SpaceContentEntityObject entity, String name, String sortKey, String stylesheetClass, List pages, List columns) {
        this.entity = entity;
        this.setName(name);
        this.pages = pages;
        this.columns = columns;
        this.rows = Collections.synchronizedList(new ArrayList());
        this.sortType = (char)(sortKey.equals(SORT_NAME) ? 83 : 70);
        this.stylesheetClass = TextUtils.stringSet((String)stylesheetClass) ? stylesheetClass : DEFAULT_STYLESHEET_CLASS;
        for (Page child : pages) {
            long date;
            Row row = new Row(child, this.id);
            if (sortKey.equals(SORT_MODIFIED)) {
                date = child.getLastModificationDate().getTime();
                row.setPageDateSortValue(date);
                row.setPageSortValue(Long.toString(date));
            } else if (sortKey.equals(SORT_CREATED)) {
                date = child.getCreationDate().getTime();
                row.setPageDateSortValue(date);
                row.setPageSortValue(Long.toString(date));
            } else {
                row.setPageSortValue(Checklist.makeSortValue(child.getTitle()));
            }
            this.rows.add(row);
        }
        Collections.sort(this.rows, new Comparator(){

            public int compare(Object o1, Object o2) {
                Row r1 = (Row)o1;
                Row r2 = (Row)o2;
                if (Checklist.this.sortType == 'S') {
                    return r1.getPageSortValue().compareTo(r2.getPageSortValue());
                }
                if (r1.getPageDateSortValue() <= r2.getPageDateSortValue()) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public static String makeSortValue(String value) {
        if (!TextUtils.stringSet((String)value)) {
            return "0000000000";
        }
        char[] chars = value.toCharArray();
        int size = 0;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; size < 20 && i < chars.length; ++i) {
            char ch = chars[i];
            if (!Character.isLetterOrDigit(ch) && ch != '.' && ch != '-') continue;
            sb.append(Character.toUpperCase(ch));
            ++size;
        }
        return sb.toString();
    }

    public String getStylesheetClass() {
        return this.stylesheetClass;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.id = ChecklistManager.makeId(name);
    }

    public String getId() {
        return this.id;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Set<String> getUniqueColumnTypes() {
        HashSet<String> columnNames = new HashSet<String>();
        for (Column column : this.columns) {
            columnNames.add(column.getTypeName());
        }
        return columnNames;
    }

    public char getSortType() {
        return this.sortType;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public String getEntityId() {
        return this.entity.getIdAsString();
    }

    public SpaceContentEntityObject getEntity() {
        return this.entity;
    }
}

