/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.changelog.ChangeLogManager;
import com.comalatech.confluence.changelog.model.ChangeLogEntry;
import com.comalatech.confluence.checklists.ChecklistManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.util.StringUtils;

public class ChecklistLogMacro
extends BaseMacro
implements Macro {
    private static final String PARAM_PAGE = "page";
    private static final String PARAM_MAXENTRIES = "maxentries";
    private static final String PARAM_MAXENTRIESPERNAME = "maxentriespername";
    private static final String PARAM_MOSTRECENTFIRST = "mostrecentfirst";
    private static final String PARAM_FORMAT = "format";
    public static final String[] FORMATS = new String[]{"date", "dateanduser", "detailed", "newvalue", "oldvalue", "simple", "user", "useranddate"};
    private final ChecklistManager checklistManager;
    private final ChangeLogManager changeLogManager;
    private final SubRenderer subRenderer;
    private final UserAccessor userAccessor;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;

    public ChecklistLogMacro(ChecklistManager checklistManager, ChangeLogManager changeLogManager, SubRenderer subRenderer, UserAccessor userAccessor, FormatSettingsManager formatSettingsManager, LocaleManager localeManager) {
        this.checklistManager = checklistManager;
        this.changeLogManager = changeLogManager;
        this.subRenderer = subRenderer;
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
    }

    public boolean hasBody() {
        return false;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        try {
            return this.execute(parameters, body, (RenderContext)context.getPageContext());
        }
        catch (MacroException e) {
            throw new MacroExecutionException(e.getMessage());
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String pageTitle = (String)parameters.get(PARAM_PAGE);
        String strmaxentries = (String)parameters.get(PARAM_MAXENTRIES);
        String strmaxentriespername = (String)parameters.get(PARAM_MAXENTRIESPERNAME);
        String strmostrencentfirst = (String)parameters.get(PARAM_MOSTRECENTFIRST);
        String format = (String)parameters.get(PARAM_FORMAT);
        Page page = (Page)((PageContext)renderContext).getEntity();
        if (TextUtils.stringSet((String)pageTitle) && (page = this.checklistManager.getPageByTitleAndSpace(page.getSpaceKey(), pageTitle)) == null) {
            throw new MacroException("page " + pageTitle + " does not exist");
        }
        int maxEntries = 0;
        if (TextUtils.stringSet((String)strmaxentries)) {
            try {
                maxEntries = Integer.parseInt(strmaxentries);
            }
            catch (NumberFormatException e) {
                throw new MacroException(" invalid value for maxentries");
            }
        }
        int maxEntriesPerName = 0;
        if (TextUtils.stringSet((String)strmaxentriespername)) {
            try {
                maxEntriesPerName = Integer.parseInt(strmaxentriespername);
            }
            catch (NumberFormatException e) {
                throw new MacroException(" invalid value for maxentriespername");
            }
        }
        if (TextUtils.stringSet((String)format) && Arrays.binarySearch(FORMATS, format) < 0) {
            throw new MacroException("format can only be one of " + StringUtils.arrayToCommaDelimitedString((Object[])FORMATS));
        }
        boolean mostRecentFirst = !TextUtils.stringSet((String)strmostrencentfirst) || !strmostrencentfirst.equals("false");
        List<String> valueNames = this.parseValueNames(parameters);
        List<ChangeLogEntry> logEntries = this.changeLogManager.getChangeLog((ContentEntityObject)page, valueNames, maxEntries, maxEntriesPerName, mostRecentFirst);
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("logEntries", logEntries);
        contextMap.put("dateFormatter", this.getDateFormatter());
        contextMap.put(PARAM_FORMAT, format);
        try {
            return this.subRenderer.render(VelocityUtils.getRenderedTemplate((String)"templates/changehistory.vm", (Map)contextMap), renderContext);
        }
        catch (Exception e) {
            throw new MacroException((Throwable)e);
        }
    }

    public DateFormatter getDateFormatter() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.userAccessor.getConfluenceUserPreferences((User)user).getDateFormatter(this.formatSettingsManager, this.localeManager);
    }

    public List<String> parseValueNames(Map parameters) {
        String strallparams = parameters.get(": = | RAW | = :") != null ? (String)parameters.get(": = | RAW | = :") : "";
        ArrayList allparams = Lists.newArrayList((Object[])strallparams.split("\\|"));
        ArrayList valueNames = Lists.newArrayList((Iterable)Iterables.filter((Iterable)allparams, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return TextUtils.stringSet((String)input) && input.indexOf("=") < 0;
            }
        }));
        return valueNames;
    }
}

