/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.v2.RenderMode;
import com.comalatech.confluence.checklists.CellHandler;
import com.comalatech.confluence.checklists.model.Column;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class LabelCellHandler
extends CellHandler {
    @Override
    public String getValue(SpaceContentEntityObject entity, Page page, Column column) {
        return Boolean.toString(page.getLabels().contains(column.getLabel()));
    }

    @Override
    public String makeSortValue(String value) {
        return Boolean.TRUE.toString().equals(value) ? "1" : "0";
    }

    @Override
    public void setValue(SpaceContentEntityObject entity, Page page, Column column, String value) {
        boolean setLabel;
        boolean bl = setLabel = !TextUtils.stringSet((String)value) || !value.equals("true");
        if (setLabel) {
            this.getChecklistManager().addLabel(page, column.getLabel());
        } else {
            this.getChecklistManager().removeLabel(page, column.getLabel());
        }
    }

    @Override
    public RenderMode getRenderMode() {
        return null;
    }

    @Override
    public Map makeContextMap() {
        Map map = super.makeContextMap();
        map.put("checkboxMethod", "changeLabel");
        return map;
    }

    @Override
    public String getTemplate(Column column) {
        return "templates/checkboxcell.vm";
    }
}

