/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.pages.Page;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.comalatech.confluence.adhoccanvas.macro.AdhocCanvasColumn;
import com.comalatech.confluence.adhoccanvas.macro.AdhocMetadataColumnMacro;
import com.comalatech.confluence.checklists.ValueManager;
import com.comalatech.confluence.checklists.macro.AbstractColumnMacro;
import com.comalatech.confluence.checklists.model.Column;
import com.comalatech.confluence.checklists.model.ColumnType;
import com.opensymphony.util.TextUtils;
import java.util.Map;

@AdhocCanvasColumn(value=AdhocMetadataColumnMacro.class)
public class ChecklistMetadataMacro
extends AbstractColumnMacro {
    public static final String PARAM_NAME = "name";
    final MacroManager macroManager;

    public ChecklistMetadataMacro(ValueManager valueManager, PluginAccessor pluginAccessor, MacroManager macroManager) {
        super(valueManager, pluginAccessor);
        this.macroManager = macroManager;
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public void parseColumnParameters(Page page, Map parameters, String body, Column column) throws MacroException {
        String name = this.getParameter(page, parameters, PARAM_NAME);
        if (!TextUtils.stringSet((String)name)) {
            name = column.getHeading();
        }
        column.setType(5);
        column.setTypeName(ColumnType.METADATA.typeName);
        if (this.macroManager.getEnabledMacro("metadata-from") != null) {
            column.setBody("{metadata-from:" + name + "}");
        } else {
            column.setBody("{checklist-attribute:attribute=" + name + "}");
        }
        column.setReadOnly(true);
    }
}

