/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.checklists.ValueManager;
import com.comalatech.confluence.checklists.macro.AbstractColumnMacro;
import com.comalatech.confluence.checklists.model.Column;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class ChecklistColumnMacro
extends AbstractColumnMacro {
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_OLDHEADING = "heading";
    private static final String PARAM_LABEL = "label";

    public ChecklistColumnMacro(ValueManager valueManager, PluginAccessor pluginAccessor) {
        super(valueManager, pluginAccessor);
    }

    @Override
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        parameters.put(PARAM_OLDHEADING, parameters.get(PARAM_OLDHEADING));
        return super.execute(parameters, body, renderContext);
    }

    @Override
    public void parseColumnParameters(Page page, Map parameters, String body, Column column) throws MacroException {
        String strtype = (String)parameters.get(PARAM_TYPE);
        String label = (String)parameters.get(PARAM_LABEL);
        String cols = (String)parameters.get("cols");
        String rows = (String)parameters.get("rows");
        if (!TextUtils.stringSet((String)strtype)) {
            throw new MacroException("column type not set");
        }
        int type = Column.parseType(strtype);
        if (type == 0) {
            throw new MacroException("invalid column type " + type);
        }
        column.setType(type);
        switch (column.getType()) {
            case 1: {
                if (!TextUtils.stringSet((String)label)) {
                    throw new MacroException("label not set in column " + column.getHeading());
                }
                if (LabelParser.parse((String)label, (User)AuthenticatedUserThreadLocal.get()) == null) {
                    throw new MacroException("labels cannot contain " + LabelParser.getInvalidCharactersAsString());
                }
                column.setLabel(label);
                break;
            }
            case 2: {
                if (column.isReadOnly()) {
                    column.setType(5);
                    column.setBody("{checklist-attribute:attribute=" + column.getKey() + "}");
                } else {
                    column.setType(6);
                    if (!TextUtils.stringSet((String)cols)) {
                        throw new MacroException("cols not set in column " + column.getHeading());
                    }
                    try {
                        column.setCols(Integer.parseInt(cols));
                    }
                    catch (NumberFormatException e) {
                        throw new MacroException("invalid cols in column " + column.getHeading());
                    }
                }
                if (TextUtils.stringSet((String)rows)) {
                    try {
                        column.setRows(Integer.parseInt(rows));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new MacroException("invalid rows in column " + column.getHeading());
                    }
                }
                column.setRows(1);
                break;
            }
            case 3: {
                column.setReadOnly(true);
                break;
            }
            default: {
                throw new MacroException("invalid column type " + strtype + " in column " + column.getHeading());
            }
        }
    }
}

