/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.license;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.comalatech.confluence.checklists.license.ChecklistLicenseManager;
import java.util.Map;

public class DefaultChecklistLicenseManager
implements ChecklistLicenseManager {
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager licenseManager;
    private static final String LICENSE_MSG_TEMPLATE = "templates/licenseMessage.vm";

    public DefaultChecklistLicenseManager(I18nResolver i18nResolver, PluginLicenseManager licenseManager) {
        this.i18nResolver = i18nResolver;
        this.licenseManager = licenseManager;
    }

    @Override
    public Option<PluginLicense> getLicense() {
        return this.licenseManager.getLicense();
    }

    @Override
    public boolean isLicensed() {
        PluginLicense pluginLicense;
        return this.licenseManager.getLicense().isDefined() && !(pluginLicense = (PluginLicense)this.licenseManager.getLicense().get()).getError().isDefined();
    }

    @Override
    public String getLicenseMessageHtml() {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("licenseManager", this);
        contextMap.put("i18nResolver", this.i18nResolver);
        contextMap.put("license", this.getLicense());
        return VelocityUtils.getRenderedTemplate((String)LICENSE_MSG_TEMPLATE, (Map)contextMap);
    }

    @Override
    public boolean isDevelopmentMode() {
        boolean isAtlassianDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
        boolean isComalatechDevMode = Boolean.parseBoolean(System.getProperty("comalatech.dev", "false"));
        return isAtlassianDevMode && isComalatechDevMode && this.isConfluenceDevLicence();
    }

    private boolean isConfluenceDevLicence() {
        LicenseType type;
        com.atlassian.license.LicenseType licenseType;
        License confluenceLicense = LicenseManager.getInstance().getLicense("CONF");
        return confluenceLicense != null && (licenseType = confluenceLicense.getLicenseType()) != null && (LicenseType.DEVELOPER.equals((Object)(type = LicenseType.valueOf((String)licenseType.getNewLicenseTypeName()))) || LicenseType.TESTING.equals((Object)type));
    }
}

