/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoccanvas.macro;

import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoccanvas.UnsupportedFeatureException;
import com.comalatech.confluence.adhoccanvas.macro.AbstractAdhocColumnMacro;
import com.comalatech.confluence.adhoccanvas.model.AdhocColumn;
import com.comalatech.confluence.adhoccanvas.model.types.SelectLabelColumn;
import com.comalatech.confluence.adhoccanvas.model.types.SelectValueColumn;
import com.comalatech.confluence.adhoccanvas.model.types.SelectableColumn;
import com.comalatech.confluence.checklists.ValueManager;
import com.opensymphony.util.TextUtils;
import java.util.StringTokenizer;

public class AdhocSelectColumnMacro
extends AbstractAdhocColumnMacro {
    public AdhocSelectColumnMacro(ValueManager valueManager) {
        super(valueManager);
    }

    @Override
    public AdhocColumn makeColumn(AbstractAdhocColumnMacro.ColumnParameters parameters) throws MacroExecutionException {
        SelectableColumn column;
        boolean useLabels = parameters.getFlag("uselabels");
        String usersGroup = parameters.get("usersgroup");
        if (useLabels) {
            column = new SelectLabelColumn(parameters.heading);
        } else {
            if (TextUtils.stringSet((String)usersGroup)) {
                throw new UnsupportedFeatureException("User selection is not supported in Comala Canvas");
            }
            column = new SelectValueColumn(parameters.heading);
        }
        this.addOptions(column, parameters.body, useLabels);
        return column;
    }

    private void addOptions(SelectableColumn column, String body, boolean uselabels) throws MacroExecutionException {
        if (TextUtils.stringSet((String)body)) {
            StringTokenizer options = new StringTokenizer(body, "\r\n");
            while (options.hasMoreTokens()) {
                String option;
                String id;
                String optionline = options.nextToken().trim();
                if (optionline.length() <= 0) continue;
                int ix = optionline.indexOf("|");
                if (ix > 0) {
                    id = optionline.substring(0, ix);
                    option = optionline.substring(ix + 1);
                } else {
                    id = option = optionline;
                }
                if (uselabels && LabelParser.parse((String)id, (User)AuthenticatedUserThreadLocal.get()) == null) {
                    throw new MacroExecutionException("Options to be used to label pages must have ids that do not include " + LabelParser.getInvalidCharactersAsString() + " in column " + column.getHeader());
                }
                column.addOption(id, option);
            }
        }
    }
}

