/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.utils;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.comalatech.confluence.checklists.content.ComalaPropertiesSetManager;
import com.comalatech.confluence.utils.MetadataSerializer;
import java.util.Arrays;
import java.util.List;

public class DefaultMetadataSerializer
implements MetadataSerializer {
    public static final String METADATA_KEY = "metadata.";
    public static final String METADATA_NAMES_KEY = "metadatakeys";
    public static final char METADATA_KEYS_SEPARATOR = '|';
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final ConfluenceIndexer indexer;

    public DefaultMetadataSerializer(ComalaPropertiesSetManager contentPropertyManager, ConfluenceIndexer indexer) {
        this.contentPropertyManager = contentPropertyManager;
        this.indexer = indexer;
    }

    private String makeMetadataKey(String valueName) {
        return METADATA_KEY + valueName.trim();
    }

    @Override
    public String[] getMetadataNames(ContentEntityObject ceo) {
        String metadataKeysString = this.getMetadataNamesString(ceo);
        if (metadataKeysString == null || metadataKeysString.length() == 0) {
            return new String[0];
        }
        return metadataKeysString.split("\\|");
    }

    @Override
    public String getMetadataNamesString(ContentEntityObject ceo) {
        return this.contentPropertyManager.getTextProperty(ceo, METADATA_NAMES_KEY);
    }

    private void registerMetadataName(ContentEntityObject ceo, String valueName) {
        String metadataNamesString = this.contentPropertyManager.getTextProperty(ceo, METADATA_NAMES_KEY);
        String newMetadataNamesString = this.addMetadataName(metadataNamesString, valueName);
        if (!newMetadataNamesString.equals(metadataNamesString)) {
            this.contentPropertyManager.setTextProperty(ceo, METADATA_NAMES_KEY, newMetadataNamesString);
        }
    }

    @Override
    public String addMetadataName(String namesString, String name) {
        if (name == null || name.length() == 0) {
            return namesString;
        }
        if (namesString == null || namesString.length() == 0) {
            return name;
        }
        List<String> names = Arrays.asList(namesString.split("\\|"));
        if (!names.contains(name)) {
            return namesString + '|' + name;
        }
        return namesString;
    }

    @Override
    public String getMetadataValue(ContentEntityObject ceo, String valueName) {
        String key = this.makeMetadataKey(valueName);
        return this.contentPropertyManager.getTextProperty(ceo, key);
    }

    @Override
    public void setMetadataValue(ContentEntityObject ceo, String valueName, String value) {
        String key = this.makeMetadataKey(valueName);
        this.contentPropertyManager.setTextProperty(ceo, key, value);
        this.registerMetadataName(ceo, valueName);
        this.indexer.reIndex((Searchable)ceo);
    }
}

