/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Page;
import java.util.HashMap;
import java.util.Map;

public class Row {
    private Page page;
    private String renderedPageLink;
    private Map values = new HashMap();
    private Map sortValues;
    private Map renderedValues = new HashMap();
    private Map cellIds;
    private boolean readOnly;
    private String pageSortValue;
    private long pageDateSortValue;
    private String id;
    private String genericId;

    public Row(Page page, String checklistId) {
        this.sortValues = new HashMap();
        this.cellIds = new HashMap();
        this.page = page;
        this.readOnly = false;
        this.id = new StringBuffer(checklistId).append('_').append(page.getIdAsString()).append('_').toString();
        this.genericId = new StringBuffer(page.getIdAsString()).toString();
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public boolean isLabelSet(Label label) {
        return this.page.getLabels().contains(label);
    }

    public void setValues(Object columnKey, String cellId, String value, String sortValue, String renderedValue) {
        this.cellIds.put(columnKey, cellId);
        this.values.put(columnKey, value);
        this.sortValues.put(columnKey, sortValue);
        this.renderedValues.put(columnKey, renderedValue);
    }

    public long getPageDateSortValue() {
        return this.pageDateSortValue;
    }

    public void setPageDateSortValue(long pageDateSortValue) {
        this.pageDateSortValue = pageDateSortValue;
    }

    public String getPageSortValue() {
        return this.pageSortValue;
    }

    public void setPageSortValue(String pageSortValue) {
        this.pageSortValue = pageSortValue;
    }

    public String getId() {
        return this.id;
    }

    public String getGenericId() {
        return this.genericId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getCellId(Object columnKey) {
        return (String)this.cellIds.get(columnKey);
    }

    public String getValue(Object columnKey) {
        return (String)this.values.get(columnKey);
    }

    public String getSortValue(Object columnKey) {
        return (String)this.sortValues.get(columnKey);
    }

    public String getRenderedValue(Object columnKey) {
        return (String)this.renderedValues.get(columnKey);
    }

    public void setRenderedPageLink(String renderedPageLink) {
        this.renderedPageLink = renderedPageLink;
    }

    public String getRenderedPageLink() {
        return this.renderedPageLink;
    }
}

