/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoccanvas.macro.AdhocCanvasColumn;
import com.comalatech.confluence.adhoccanvas.macro.AdhocLabelColumnMacro;
import com.comalatech.confluence.checklists.ValueManager;
import com.comalatech.confluence.checklists.macro.AbstractColumnMacro;
import com.comalatech.confluence.checklists.model.Column;
import com.comalatech.confluence.checklists.model.ColumnType;
import com.opensymphony.util.TextUtils;
import java.util.Map;

@AdhocCanvasColumn(value=AdhocLabelColumnMacro.class)
public class ChecklistLabelMacro
extends AbstractColumnMacro {
    private static final String PARAM_LABEL = "label";

    public ChecklistLabelMacro(ValueManager valueManager, PluginAccessor pluginAccessor) {
        super(valueManager, pluginAccessor);
    }

    @Override
    public void parseColumnParameters(Page page, Map parameters, String body, Column column) throws MacroException {
        column.setType(1);
        column.setTypeName(ColumnType.LABEL.typeName);
        String label = this.getParameter(page, parameters, PARAM_LABEL);
        if (!TextUtils.stringSet((String)label) && column.getHeading() != null) {
            label = column.getHeading().toLowerCase();
        }
        if (LabelParser.parse((String)label, (User)AuthenticatedUserThreadLocal.get()) == null) {
            throw new MacroException("labels cannot contain " + LabelParser.getInvalidCharactersAsString() + " in column " + column.getHeading());
        }
        column.setLabel(label);
    }
}

