/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.adhoccanvas.macro.AbstractAdhocColumnMacro;
import com.comalatech.confluence.adhoccanvas.macro.AdhocCanvasColumn;
import com.comalatech.confluence.checklists.ValueManager;
import com.comalatech.confluence.checklists.model.Column;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class AbstractColumnMacro
extends BaseMacro
implements Macro {
    public static final String COLUMNS_KEY = "com.comalatech.checklists:columns";
    public static final String COLUMN_ERROR_KEY = "com.comalatech.checklists:column-error";
    private static final String PARAM_0 = "0";
    protected static final String PARAM_HEADING = "heading";
    private static final String PARAM_READONLY = "readonly";
    private static final String PARAM_WIDTH = "width";
    protected static final String PARAM_COLS = "cols";
    protected static final String PARAM_ROWS = "rows";
    private static final String PARAM_TYPE = "sorttype";
    private static final String PARAM_STORE = "store";
    private static final String PARAM_CLASS = "class";
    private static final String STORE_ROWS = "rows";
    private static final String STORE_CHECKLIST = "checklist";
    private static final char[] SORT_TYPES = new char[]{'A', 'C', 'D', 'F', 'I', 'S'};
    private static final String SORT_TYPES_AS_STRING = "A, C, D, F, I, S";
    private final ValueManager valueManager;
    private final PluginAccessor pluginAccessor;

    public AbstractColumnMacro(ValueManager valueManager, PluginAccessor pluginAccessor) {
        this.valueManager = valueManager;
        this.pluginAccessor = pluginAccessor;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    protected boolean isAdhocCanvasInstalled() {
        return this.pluginAccessor.isPluginEnabled("com.comalatech.adhoccanvas");
    }

    protected String getParameter(Page page, Map parameters, String paramName) {
        return this.valueManager.replaceKeywords((ContentEntityObject)page, (String)parameters.get(paramName));
    }

    private Column parseHeading(Page page, Map parameters) throws MacroException {
        boolean readonly;
        char sortType;
        String heading = this.getParameter(page, parameters, PARAM_HEADING);
        if (!TextUtils.stringSet((String)heading)) {
            heading = this.getParameter(page, parameters, PARAM_0);
        }
        String width = this.getParameter(page, parameters, PARAM_WIDTH);
        String strreadonly = this.getParameter(page, parameters, PARAM_READONLY);
        String sortTypeStr = this.getParameter(page, parameters, PARAM_TYPE);
        String store = this.getParameter(page, parameters, PARAM_STORE);
        String stylesheetClass = this.getParameter(page, parameters, PARAM_CLASS);
        if (!TextUtils.stringSet((String)sortTypeStr)) {
            sortType = 'S';
        } else {
            sortType = sortTypeStr.charAt(0);
            this.checkSortType(sortType);
        }
        if (!TextUtils.stringSet((String)store)) {
            store = "rows";
        } else if (!store.equalsIgnoreCase("rows") && !store.equalsIgnoreCase(STORE_CHECKLIST)) {
            throw new MacroException("'store' should be either 'rows' or 'checklist'");
        }
        boolean bl = readonly = TextUtils.stringSet((String)strreadonly) && strreadonly.equals("true");
        if (!TextUtils.stringSet((String)heading)) {
            throw new MacroException("column heading not set");
        }
        return new Column(heading, width, stylesheetClass, sortType, readonly, store.equalsIgnoreCase("rows"));
    }

    public abstract void parseColumnParameters(Page var1, Map var2, String var3, Column var4) throws MacroException;

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Column column;
        Page page = (Page)((PageContext)renderContext).getEntity();
        try {
            column = this.parseHeading(page, parameters);
            this.parseColumnParameters(page, parameters, body, column);
        }
        catch (MacroException e) {
            renderContext.addParam((Object)COLUMN_ERROR_KEY, (Object)e.getMessage());
            throw e;
        }
        List columns = this.getColumnsList(renderContext);
        columns.add(column);
        return "";
    }

    protected AbstractAdhocColumnMacro getAdhocColumnMacro() {
        AdhocCanvasColumn adhocCanvasColumn = ((Object)((Object)this)).getClass().getAnnotation(AdhocCanvasColumn.class);
        if (adhocCanvasColumn != null) {
            try {
                return (AbstractAdhocColumnMacro)adhocCanvasColumn.value().getConstructor(ValueManager.class).newInstance(this.valueManager);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        AbstractAdhocColumnMacro adhocColumMacro;
        if (this.isAdhocCanvasInstalled() && (adhocColumMacro = this.getAdhocColumnMacro()) != null) {
            try {
                adhocColumMacro.execute(parameters, body, context);
            }
            catch (MacroExecutionException e) {
                this.addColumnError(context, e);
            }
        }
        try {
            return this.execute(parameters, body, (RenderContext)context.getPageContext());
        }
        catch (MacroException e) {
            throw new MacroExecutionException(e.getMessage());
        }
    }

    private void addColumnError(ConversionContext context, MacroExecutionException e) {
        String errorMsg = (String)context.getProperty(COLUMN_ERROR_KEY);
        errorMsg = TextUtils.stringSet((String)errorMsg) ? errorMsg + " <br>" : "";
        context.setProperty(COLUMN_ERROR_KEY, (Object)(errorMsg + e.getMessage()));
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private List getColumnsList(RenderContext renderContext) {
        ArrayList list = (ArrayList)renderContext.getParam((Object)COLUMNS_KEY);
        if (list == null) {
            list = new ArrayList();
            renderContext.addParam((Object)COLUMNS_KEY, list);
        }
        return list;
    }

    private void checkSortType(char type) throws MacroException {
        if (Arrays.binarySearch(SORT_TYPES, type) >= 0) {
            return;
        }
        throw new MacroException("Invalid sort type " + type + " it can be only one of " + SORT_TYPES_AS_STRING);
    }
}

