/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.changelog;

import com.atlassian.confluence.compat.setup.xstream.XStreamManagerCompat;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.changelog.ChangeLogEntryComparator;
import com.comalatech.confluence.changelog.model.ChangeLogEntry;
import com.comalatech.confluence.utils.MetadataSerializer;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeLogManager {
    private static final Logger log = LoggerFactory.getLogger(ChangeLogManager.class);
    private static final String CHANGELOG_PREFIX = "changelog.";
    private final XStreamManagerCompat xStreamManagerCompat;
    private final MetadataSerializer metadataSerializer;

    public ChangeLogManager(MetadataSerializer metadataSerializer, XStreamManagerCompat xStreamManagerCompat) {
        this.metadataSerializer = metadataSerializer;
        this.xStreamManagerCompat = xStreamManagerCompat;
    }

    public void logChange(ContentEntityObject contentEntityObject, String valueName, String oldValue, String newValue) {
        this.logChange(contentEntityObject, valueName, oldValue, newValue, false);
    }

    public void logLabelChange(ContentEntityObject contentEntityObject, String labelName, boolean added) {
        this.logChange(contentEntityObject, labelName, null, added ? "Added" : "Removed", true);
    }

    private void logChange(ContentEntityObject contentEntityObject, String valueName, String oldValue, String newValue, boolean isLabel) {
        if (valueName.startsWith(CHANGELOG_PREFIX)) {
            return;
        }
        String key = this.makeChangeLogKey(valueName);
        List<ChangeLogEntry> changeLog = this.getChangeLog(contentEntityObject, key);
        ChangeLogEntry changeLogEntry = new ChangeLogEntry(AuthenticatedUserThreadLocal.get().getName(), new Date(), valueName, oldValue, newValue, isLabel);
        changeLog.add(0, changeLogEntry);
        this.setChangeLog(contentEntityObject, key, changeLog);
    }

    public List<ChangeLogEntry> getChangeLog(ContentEntityObject contentEntityObject, List<String> valueNamesList, int maxEntries, int maxEntriesPerName, boolean mostRecentFirst) {
        String[] loggedNames;
        ArrayList<ChangeLogEntry> entries = new ArrayList<ChangeLogEntry>();
        for (String loggedName : loggedNames = this.metadataSerializer.getMetadataNames(contentEntityObject)) {
            List<ChangeLogEntry> nameEntries;
            if (!loggedName.startsWith(CHANGELOG_PREFIX)) continue;
            if (valueNamesList.size() == 0) {
                nameEntries = this.getChangeLog(contentEntityObject, this.makeChangeLogKey(loggedName.substring(CHANGELOG_PREFIX.length())));
                entries.addAll(this.getChangeLogPortion(nameEntries, maxEntriesPerName, mostRecentFirst));
                continue;
            }
            if (!valueNamesList.contains(loggedName.substring(CHANGELOG_PREFIX.length()))) continue;
            nameEntries = this.getChangeLog(contentEntityObject, loggedName);
            entries.addAll(this.getChangeLogPortion(nameEntries, maxEntriesPerName, mostRecentFirst));
        }
        Collections.sort(entries, new ChangeLogEntryComparator(mostRecentFirst));
        if (maxEntries == 0 || entries.size() <= maxEntries) {
            return entries;
        }
        return entries.subList(0, maxEntries);
    }

    private List<ChangeLogEntry> getChangeLogPortion(List<ChangeLogEntry> allEntries, int maxEntries, boolean mostRecentFirst) {
        if (allEntries.size() == 0) {
            return allEntries;
        }
        if (!mostRecentFirst) {
            Collections.sort(allEntries, new ChangeLogEntryComparator(mostRecentFirst));
        }
        if (maxEntries == 0 || allEntries.size() <= maxEntries) {
            return allEntries;
        }
        return allEntries.subList(0, maxEntries);
    }

    private List<ChangeLogEntry> getChangeLog(ContentEntityObject contentEntityObject, String logKey) {
        String rawlog = this.metadataSerializer.getMetadataValue(contentEntityObject, logKey);
        if (!TextUtils.stringSet((String)rawlog)) {
            return new ArrayList<ChangeLogEntry>();
        }
        try {
            return (List)this.xStreamManagerCompat.fromXML(rawlog);
        }
        catch (Exception e) {
            log.error("error deserializing change log. See CHK-29", (Throwable)e);
            return new ArrayList<ChangeLogEntry>();
        }
    }

    private void setChangeLog(ContentEntityObject contentEntityObject, String logKey, List<ChangeLogEntry> changeLog) {
        String rawLog = this.xStreamManagerCompat.toXML(changeLog);
        this.metadataSerializer.setMetadataValue(contentEntityObject, logKey, rawLog);
    }

    private String makeChangeLogKey(String valueName) {
        return CHANGELOG_PREFIX + valueName;
    }
}

