/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoccanvas.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.adhoccanvas.UnsupportedFeatureException;
import com.comalatech.confluence.adhoccanvas.macro.AbstractXhtmlMacro;
import com.comalatech.confluence.adhoccanvas.model.AdhocColumn;
import com.comalatech.confluence.adhoccanvas.model.AdhocList;
import com.comalatech.confluence.adhoccanvas.model.SortType;
import com.comalatech.confluence.adhoccanvas.model.types.LabelColumn;
import com.comalatech.confluence.adhoccanvas.model.types.PageColumn;
import com.comalatech.confluence.adhoccanvas.model.types.SelectLabelColumn;
import com.comalatech.confluence.adhoccanvas.model.types.WikiInputColumn;
import com.comalatech.confluence.checklists.ValueManager;
import com.opensymphony.util.TextUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public class ChecklistXHtmlMacro
extends AbstractXhtmlMacro {
    private ObjectMapper objectMapper;
    private WikiStyleRenderer wikiStyleRenderer;

    public ChecklistXHtmlMacro(ValueManager valueManager, WikiStyleRenderer wikiStyleRenderer) {
        super(valueManager);
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.objectMapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        this.objectMapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        this.objectMapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
    }

    public String execute(Map<String, String> paramsMap, String body, ConversionContext conversionContext) throws MacroExecutionException, UnsupportedFeatureException {
        String columnError;
        Parameters params = new Parameters(paramsMap, conversionContext);
        AdhocList list = new AdhocList(params.name);
        list.setSortType(new SortType(params.sort));
        list.setLeftJustified(true);
        list.setStyle(params.cssClass);
        if (!TextUtils.stringSet((String)params.filterParent)) {
            ContentEntityObject page = conversionContext.getPageContext().getEntity();
            params.filterParent = page.getTitle();
        }
        if (params.pageLink) {
            list.addColumn(new PageColumn(params.name, PageColumn.Type.VIEWLINK));
        }
        if (TextUtils.stringSet((String)params.excerptHeading)) {
            list.addColumn(new PageColumn(params.excerptHeading, PageColumn.Type.EXCERPT));
        }
        if (params.mutuallyExclusive) {
            String[] selectLabelColumn = new SelectLabelColumn("Label");
            for (String label : this.split(params.checkLabels)) {
                selectLabelColumn.addOption(label, label);
            }
            list.addColumn((AdhocColumn)selectLabelColumn);
        } else {
            for (String label : this.split(params.checkLabels)) {
                list.addColumn(new LabelColumn(label, label));
            }
        }
        if (params.commentHeading != null) {
            list.addColumn(new WikiInputColumn(params.commentHeading, 50, 5));
        }
        StringBuffer errorMsg = new StringBuffer();
        if (params.childrenOnly) {
            errorMsg.append("'childrenonly' filter not supported in Comala Canvas <br>");
        }
        if (TextUtils.stringSet((String)(columnError = (String)conversionContext.removeProperty("com.comalatech.checklists:column-error")))) {
            errorMsg.append(columnError);
        }
        if (errorMsg.length() > 0) {
            throw new UnsupportedFeatureException(errorMsg.toString());
        }
        list.getColumns().addAll(this.removeAdhocCanvasColumnList(conversionContext));
        return this.renderChecklist(list, params.filterParent, params.filterLabel, params.space, params.depth, conversionContext, params.debug);
    }

    private String renderChecklist(AdhocList list, String filterParent, String filterLabel, String filterSpaceKey, int depth, ConversionContext conversionContext, boolean debug) throws MacroExecutionException {
        StringBuffer sb = new StringBuffer("{adhoclist");
        int params = 0;
        if (TextUtils.stringSet((String)filterParent)) {
            sb.append(":parent=").append(filterParent);
            ++params;
        }
        if (TextUtils.stringSet((String)filterLabel)) {
            sb.append(params++ > 0 ? "|" : ":");
            sb.append("labels=").append(filterLabel);
        }
        if (TextUtils.stringSet((String)filterSpaceKey)) {
            sb.append(params++ > 0 ? "|" : ":");
            sb.append("spacekey=").append(filterSpaceKey);
        }
        if (depth > 0) {
            sb.append(params++ > 0 ? "|" : ":");
            sb.append("depth=").append(depth);
        }
        String jsonList = this.toJson(list);
        sb.append("}\n").append(jsonList).append("\n{adhoclist}\n");
        String wiki = debug ? "{noformat}\n" + sb.toString() + "\n{noformat}\n" + sb.toString() : sb.toString();
        String rendered = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)conversionContext.getPageContext(), wiki);
        if (rendered.contains("class=\"error\"") && !debug) {
            throw new MacroExecutionException(jsonList);
        }
        return rendered;
    }

    private String toJson(AdhocList list) throws MacroExecutionException {
        StringWriter writer = new StringWriter();
        try {
            this.objectMapper.writeValue((Writer)writer, (Object)list);
            return writer.toString();
        }
        catch (Exception e) {
            throw new MacroExecutionException((Throwable)e);
        }
    }

    class Parameters
    extends AbstractXhtmlMacro.MacroParameters {
        String name;
        String filterParent;
        String filterLabel;
        String filterSpaceKey;
        String checkLabels;
        int depth;
        boolean childrenOnly;
        String space;
        String commentHeading;
        String excerptHeading;
        String sort;
        boolean mutuallyExclusive;
        String cssClass;
        boolean pageLink;
        boolean debug;

        public Parameters(Map<String, String> params, ConversionContext conversionContext) throws MacroExecutionException, UnsupportedFeatureException {
            super(params, conversionContext);
            this.name = this.get("name", "0");
            if (this.name == null) {
                this.name = this.getEntity().getTitle();
            }
            this.filterParent = this.get("parent");
            this.filterLabel = this.get("label");
            this.checkLabels = this.get("checklabels");
            this.filterSpaceKey = this.get("space");
            this.depth = this.getInt(0, "depth");
            this.childrenOnly = this.getFlag("childrenonly");
            this.space = this.get("space");
            this.commentHeading = this.get("comment-heading");
            this.excerptHeading = this.get("excerpt-heading");
            this.sort = this.get("sort");
            this.mutuallyExclusive = this.getFlag("mutuallyexclusive");
            this.cssClass = this.get("class");
            this.pageLink = this.getFlag(true, "pageLink");
            this.debug = this.getFlag("debug");
        }
    }
}

