/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Canvas.CML.corsSync = function(method, model, options) {
    switch (method) {
        case "read":
            var request,
                httpType = "GET",
                xdomreq = false;
            
            if (model.url.indexOf("http") == 0) {
                xdomreq = true;
                request = new XDomainRequest();
            } else {
                request = new XMLHttpRequest();
            }

            // GET is default type but can be set manually
            if(model.get('httpType')) {
                httpType = model.get('httpType').toUpperCase();
            }
            request.open(httpType, model.url);

            if (request){
                // onload is not supported in IE
                // https://developer.mozilla.org/en-US/docs/DOM/XMLHttpRequest
            	if(xdomreq) {
            	    request.onload = function(req) {
                        options.success(JSON.parse(request.responseText));
                    };
            	}
            	else {
            	    request.onreadystatechange = function () {
            	        if (request.readyState == 4 && request.status === 200) {
            	            options.success(JSON.parse(request.responseText));
            	        }
            	    };
            	}

                // have to set data to send manually when POST
                if(httpType.toUpperCase() == "POST" && model.get('httpData')) {
                    request.send(model.get('httpData'));    
                }
                else {
                    request.send();       
                }
            }
        break;
    }
};