/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */


var requirejs = require || requirejs; 

requirejs(['jquery', 'ajs', 'confluence/root'], function ($, AJS, ConfluenceRoot) {

    var selectedList = function() {
        var selected = $("#list-name-select option:selected");
        return {name : selected.text(),
                spaceList: selected.hasClass("spacelist"),
                // todo allow for actual page named labels
                popularLabels: selected.hasClass("popularlabels"),
                empty: selected.hasClass("empty"),
                importList: selected.hasClass("import"),
                listMarkup: encodeURIComponent($("#newlistmarkup").val())

        }
    };
    
    var listMacroOpener = function(macro, inserting) {
        var $content;
        var filterParams = Adhoc.filter.getFilterParams(macro);
        if (macro && macro.body && macro.body.length > 1) {
            // edit list
            var url = AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/" +
                    AJS.params.contentId + "/edit" +
                    "?parent=" + filterParams.parent +
                    "&filterspacekey=" + filterParams.spacekey +
                    "&labels=" + filterParams.labels +
                    "&depth=" + filterParams.depth ;
            $.ajax({type:"POST",
                cache:false,
                data: macro.body,
                contentType: "application/json",
                url:url,
                success: function (html, textStatus, jqXHR) {
                    var listDesignerDialog = new Canvas.CML.Dialog({ // Edit list
                        id: "listDesigner",
                        className: 'adhocmacrodialog',
                        width: 870,
                        height: 530,
                        title: AJS.I18n.getText("adhoclists.rte.lists.edit"),
                        content: html,
                        open: true,
                        remove: true,
                        actions: [
                            {
                                id: 'insert',
                                style: 'primary '+ (inserting ? 'insert-list' : 'save-list'),
                                label: inserting ? AJS.I18n.getText('insert.name') : AJS.I18n.getText('save.name'),
                                onClick: function(event) {
                                    event.preventDefault();
                                    Canvas.CML.analytics.trackEvent('checklist', 'edit');
                                    macroRenderRequest = makeUpdateChecklistMacroRequest();
                                    var t = tinymce.confluence.macrobrowser;
                                    AJS.Rte.BookmarkManager.restoreBookmark();
                                    tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest, t.editedMacroDiv);
                                    Canvas.CML.closeDialogs();
                                }
                            },
                            {
                                id: 'cancel',
                                style: 'link cancel-insert-list',
                                label: AJS.I18n.getText('cancel.name')
                            },
                        ],
                        onOpen: function() {
                            Adhoc.Checklist.init();
                            Adhoc.Checklist.checklistDesigner();
                            Adhoc.filter.init();
                        }
                    });
                    var $content = listDesignerDialog.getContent();
                    AJS.Confluence.Binder.autocompletePage($content);
                    AJS.Confluence.Binder.autocompleteSpace($content);
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Adhoc.common.errorHandler($content,jqXHR, textStatus,errorThrown);
                }
            });
        } else {
            // add list
            var currentList;
            var hideCopy = false;
            if (macro && macro.params && macro.params.name) {
                currentList = macro.params.name;
                hideCopy = true;
            } else {
                currentList = "";
            }
            $.ajax({type:"GET",
                cache:false,
                url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/" + AJS.params.spaceKey + "/select" +
                        "?name=" + encodeURIComponent(currentList) +
                        "&parent=" + filterParams.parent +
                        "&filterspacekey=" + filterParams.spacekey +
                        "&labels=" + filterParams.labels +
                        "&depth=" + filterParams.depth +
                        "&allSpaces=" + filterParams.allSpaces,
                success:function (html, textStatus, jqXHR) {
                    var insertListDialog = new Canvas.CML.Dialog({ // Add list
                        id: "insertList",
                        className: 'adhocmacrodialog',
                        width: 870,
                        height: 530,
                        title: AJS.I18n.getText("adhoclists.rte.lists.insert"),
                        content: html,
                        open: true,
                        remove: true,
                        actions: [
                            {
                                id: 'insert',
                                style: 'primary insert-list',
                                label: AJS.I18n.getText('insert.name'),
                                onClick: function () {
                                    var macroRenderRequest = makeMacroRequest();
                                    var t = tinymce.confluence.macrobrowser;
                                    AJS.Rte.BookmarkManager.restoreBookmark();
                                    tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest, t.editedMacroDiv);
                                    Canvas.CML.closeDialogs();
                                }
                            },
                            {
                                id: 'modify',
                                style: 'primary modify-list',
                                label: AJS.I18n.getText('adhoclists.continue'),
                                onClick: function () {
                                    var macroRenderRequest = makeMacroRequest();
                                    var selList = selectedList();
                                    $.ajax({type: "GET",
                                        cache: false,
                                        url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/" + macroRenderRequest.contentId + "/get" +
                                                "?name=" + encodeURIComponent(macroRenderRequest.macro.params.name) +
                                                "&space=" + macroRenderRequest.macro.params.spacelist +    //TODO deprecated per AHLISTS-478
                                                "&popularLabels=" + macroRenderRequest.macro.params.popularlabels +
                                                "&empty=" + selList.empty +
                                                "&listMarkup=" + selList.listMarkup,
                                        success: function (listMarkup, textStatus, jqXHR) {
                                            if (jqXHR.status == 200) {
                                                macroRenderRequest.macro.body = listMarkup;
                                                    if (selList.empty) {
                                                        // This is too limit the default search for a new empty list to just the children pages
                                                        macroRenderRequest.macro.params.parent = "@self";
                                                    }
                                                    Canvas.CML.closeDialogs();
                                                    listMacroOpener(macroRenderRequest.macro, true);
                                                } else {
                                                    $("#listmarkuperror").html("Invalid list markup").removeClass("hidden");
                                                }
                                            },
                                            error: function(jqXHR, textStatus, errorThrown) {
                                                Adhoc.common.errorHandler($("#insertList .dialog-page-menu"),jqXHR, textStatus,errorThrown);
                                            }
                                        });
                                }
                            },
                            {
                                id: 'cancel',
                                style: 'link cancel-insert-list',
                                label: AJS.I18n.getText('cancel.name')
                            },
                        ],
                        onOpen: function() {
                            if (hideCopy) {
                                $("#list-copy-param").addClass("hidden");
                            }
                            $("#list-name-select").focus().change();
                            Adhoc.filter.init();
                        }
                    });
                    var $content = insertListDialog.getContent();
                    AJS.Confluence.Binder.autocompletePage($content);
                    AJS.Confluence.Binder.autocompleteSpace($content);
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Adhoc.common.errorHandler($content,jqXHR, textStatus,errorThrown);
                }
            });  
        }
    };
    
    var makeMacroRequest = function () {
        var selected = selectedList();
        var request = {
            contentId:ConfluenceRoot.Editor.getContentId(),
            macro:{
                name:"adhoclist",
                params:{
                    name:selected.name
                }
            }
        };
        if (selected.popularLabels) {
            request.macro.params.popularlabels = selected.popularLabels;
        }
        Adhoc.filter.setFilterMacroParams(request);
        return request;

    };
    
    var makeUpdateChecklistMacroRequest = function () {
        Adhoc.Checklist.update();
        var request = {
            contentId:ConfluenceRoot.Editor.getContentId(),
            macro:{
                name:"adhoclist",
                body: Adhoc.Checklist.toJson(),
                params:{
                    name: Adhoc.Checklist.checklist.name
                }
            }
        };
        Adhoc.filter.setFilterMacroParams(request);
        debugo = request;
        return request;
    };
    
    var bindDialogActions = function() {

        $(document).on('change', "#copy-list", function(event) {
            if ($(this).prop("checked")) {
                $(".insert-list").addClass("hidden");
                $(".modify-list").removeClass("hidden");
                $("#adhocfilter").addClass("hidden");
            } else {
                $(".insert-list").removeClass("hidden");
                $(".modify-list").addClass("hidden");
                $("#adhocfilter").removeClass("hidden");
            }
        });

        $(document).on('change', "#list-name-select", function(event) {
            var selected = selectedList();
            if (selected.empty) {
                $("#copy-list").prop("checked","checked").change().prop("disabled","disabled");
                $("#macro-browser-preview").html("");
                $(".insert-list").addClass("hidden");
                $(".modify-list").removeClass("hidden");
                $("#bundled-list-desc").empty();
                $(".listmarkup").addClass("hidden");
                $("#boardmarkuperror").addClass("hidden");
                $(".pagetablefilter").addClass("hidden");
            } else if (selected.importList) {
                $("#copy-list").prop("checked","checked").change().prop("disabled","disabled");
                $("#macro-browser-preview").html("");
                $(".insert-list").addClass("hidden");
                $(".modify-list").removeClass("hidden");
                $("#bundled-list-desc").empty();
                $(".listmarkup").removeClass("hidden");
                $(".pagetablefilter").addClass("hidden");
            } else {
                $(".pagetablefilter").removeClass("hidden");
                $("#boardmarkuperror").addClass("hidden");
                $(".listmarkup").addClass("hidden");
                $("#copy-list").removeAttr("disabled").change();
                $(".insert-list").removeClass("hidden");
                $("#adhocfilter").removeClass("hidden");
                $(".modify-list").addClass("hidden");
                $.ajax({type: "GET",
                    cache: false,
                    url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/" + AJS.params.spaceKey + "/namedpreview" +
                            "?name=" + selected.name + "&space=" + selected.spaceList + "&popularLabels=" + selected.popularLabels
                            ,
                    success: function (html, textStatus, jqXHR) {
                        $("#macro-browser-preview.macro-preview-dialog").html(html);
                        var description = $(".list-desc").html();
                        $("#bundled-list-desc").html(description);
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        Adhoc.common.errorHandler($("#macro-browser-preview.macro-preview-dialog"),jqXHR, textStatus,errorThrown);
                    }

                });
            }
        });

        $(document).on('click', ".cancel-insert-list", Canvas.CML.closeDialogs);
                // for some bloody reason, the aui tabs don't work on a macro-brower panel :-(
        $(document).on('click', ".aui-tabs.checklist li.menu-item a", function(event) {
            event.preventDefault();
            var tabs = $(this).parents(".aui-tabs");
            tabs.find(".menu-item").removeClass("active-tab");
            $(this).parents("li").addClass("active-tab");
            tabs.find(".tabs-pane").removeClass("active-pane");
            $($(this).attr("href")).addClass("active-pane");
        });


    };

    AJS.bind("init.rte", function() {
        AJS.log("init lists-rte");
        AJS.MacroBrowser.setMacroJsOverride("adhoclist", {opener: listMacroOpener});
        bindDialogActions();
    });
});

