/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;

requirejs(
    ['cb', 'ajs', 'tinymce'],
    function (CB, AJS, tinymce) {
        var editorWidth = 800;
        var editorHeight = 550;
        var Dialog;
        var customData;

        CB.toInit(function () {
            var spaceKey = CB.getParam('spaceKey').trim();
            var type = spaceKey ? 'macro' : 'template';
            var pageId = CB.getParam('pageId');
            var path = type + '/' + (spaceKey ? spaceKey + '/' : '') + pageId;

            var BuilderDialog = new CB.Dialog({
                id: "board-macro-builder",
                width: editorWidth,
                height: editorHeight,
                path: '/boards/builder/' + path,
                customData: function () { return customData },
                reloadEvent: 'AppReload',
            });
            var PickerDialog = new CB.Dialog({
                id: "board-macro-picker",
                width: editorWidth,
                height: editorHeight,
                path: '/boards/picker/' + path,
                closeable: false
            });

            function boardMacro(macro) {
                AJS.Rte.BookmarkManager.storeBookmark();
                if (macro && macro.body && macro.body.length > 1) {
                    // Edit Board
                    customData = { board: JSON.parse(macro.body) };
                    Dialog = BuilderDialog;
                } else {
                    // Insert Board
                    Dialog = PickerDialog;
                }
                Dialog.show();
            }
            // Insert New Board Macro
            CB.connect('insertBoardMacro', function (board) {
                var macroBrowser = tinymce.confluence.macrobrowser;
                var macroUtils = tinymce.confluence.MacroUtils;
                var labels;
                if (board.filter && board.filter.labels) {
                    labels = board.filter.labels.join(',');
                }
                var macroRequest = {
                    contentId: pageId,
                    macro: {
                        name: 'adhocboard',
                        body: JSON.stringify(board),
                        params: Object.assign(
                            {},
                            board.filter,
                            { name: board.name, labels: labels }
                        )
                    }
                };
                AJS.Rte.BookmarkManager.restoreBookmark();
                macroUtils.insertMacro(macroRequest, macroBrowser.editedMacroDiv);
            });

            // Toggle full screen mode
            CB.connect('fullScreen', function (isFullScreen) {
                if (Dialog && Dialog.getState('open')) {
                    Dialog.resize({
                        width: isFullScreen ? $(window).width() : editorWidth,
                        height: isFullScreen ? $(window).height() : editorHeight
                    });
                }
            });

            // Setup Board Picker & Board Builder
            AJS.MacroBrowser.setMacroJsOverride('adhocboard', { opener: boardMacro });
        });
    }
);
