/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.macro;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.adhoclists.lists.macro.MacroParameters;
import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BoardMacroParameters
extends MacroParameters {
    private static final String PARAM_ID = "id";
    private static final String PARAM_LABELS = "labels";
    private static final String PARAM_READ_ONLY = "readonly";
    private static final String PARAM_PARENT = "parent";
    private static final String PARAM_SPACEKEY = "spaceKey";
    private static final String[] PARAM_NAME = new String[]{"name", "0"};
    public String id;
    public String macroId;
    public String name;
    public boolean preview;
    public String body;
    public boolean readOnly;
    public Filter filter;
    public String spaceKey;
    public String outputType;
    public boolean hostPageIncluded;

    public BoardMacroParameters(String macroId, Map<String, String> parameters, String body, PageContext pageContext) throws MacroException {
        super(parameters, (RenderContext)pageContext);
        this.macroId = macroId;
        this.id = this.get(PARAM_ID);
        this.spaceKey = pageContext.getSpaceKey();
        this.filter = new Filter();
        this.filter.setParent(this.get(PARAM_PARENT));
        this.filter.setAllSpaces(Boolean.parseBoolean(parameters.get("allSpaces")));
        String spaceKey = this.get(PARAM_SPACEKEY);
        this.filter.setSpaceKey(StringUtils.isNotBlank((CharSequence)spaceKey) ? spaceKey : this.get("spacekey"));
        this.filter.setLabels(Arrays.asList(AdhocListsUtils.splitAndTrim(this.get(PARAM_LABELS))));
        this.filter.setDepth(StringUtils.isNotBlank((CharSequence)parameters.get("depth")) ? Integer.parseInt(parameters.get("depth")) : 0);
        this.name = this.get(PARAM_NAME, true);
        this.readOnly = BoardMacroParameters.getBooleanValue(parameters, PARAM_READ_ONLY, false);
        if (StringUtils.isNotBlank((CharSequence)body) && StringUtils.isNotBlank((CharSequence)(body = AdhocListsUtils.clean(body)))) {
            this.body = body.trim();
        }
        this.outputType = pageContext.getOutputType();
        this.hostPageIncluded = pageContext.getOriginalContext().getEntity().getId() != pageContext.getEntity().getId();
        this.readOnly = !this.readOnly && this.hostPageIncluded ? this.hostPageIncluded : this.readOnly;
    }

    private static boolean getBooleanValue(Map<String, String> parameters, String key, boolean defaultValue) {
        if (parameters == null || !parameters.containsKey(key)) {
            return defaultValue;
        }
        String value = parameters.get(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }
}

