/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.utils;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.core.datetime.RequestTimeThreadLocal;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.user.User;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import org.springframework.stereotype.Component;

@Component
public class UserDateFormatter {
    private FriendlyDateFormatter pageDateFormatter;
    private DateFormatter dateFormatter;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final UserAccessor userAccessor;
    private final TimeZoneManager timeZoneManager;

    public UserDateFormatter(@ComponentImport FormatSettingsManager formatSettingsManager, @ComponentImport LocaleManager localeManager, @ComponentImport UserAccessor userAccessor, @ComponentImport TimeZoneManager timeZoneManager) {
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.userAccessor = userAccessor;
        this.timeZoneManager = timeZoneManager;
    }

    public String formatFriendlyDate(Date date) {
        Message message = this.getPageDateFormatter().getFormatMessage(date);
        return ComalaI18nBean.getComalaI18nBean().getText(message.getKey(), message.getArguments());
    }

    private FriendlyDateFormatter getPageDateFormatter() {
        if (this.pageDateFormatter == null) {
            this.pageDateFormatter = new FriendlyDateFormatter(RequestTimeThreadLocal.getTimeOrNow(), this.getDateFormatter());
        }
        return this.pageDateFormatter;
    }

    private DateFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new DateFormatter(this.getTimeZone(), this.formatSettingsManager, this.localeManager);
        }
        return this.dateFormatter;
    }

    private com.atlassian.confluence.core.TimeZone getTimeZone() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (Objects.isNull(confluenceUser)) {
            return this.getDefaultTimeZone();
        }
        return this.userAccessor.getConfluenceUserPreferences((User)confluenceUser).getTimeZone();
    }

    private com.atlassian.confluence.core.TimeZone getDefaultTimeZone() {
        return this.timeZoneManager == null ? com.atlassian.confluence.core.TimeZone.getInstance((String)TimeZone.getDefault().getID()) : com.atlassian.confluence.core.TimeZone.getInstance((String)this.timeZoneManager.getDefaultTimeZone().getID());
    }
}

