/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage.serializer;

import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.storage.serializer.Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class TableJasonSerializer<T extends Table>
implements Serializer<T>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TableJasonSerializer.class);
    protected ObjectMapper mapper;

    @Override
    public String serialize(T table) {
        StringWriter writer = new StringWriter();
        try {
            this.mapper.writeValue(writer, table);
            return writer.toString();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    protected abstract Class getTableClass();

    @Override
    public T deserialize(String table) {
        try {
            return (T)((Table)this.mapper.readValue(table, this.getTableClass()));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Error deserializing " + table, (Throwable)e);
            } else {
                log.error("Error deserializing " + table);
            }
            return null;
        }
    }

    @Override
    public T deserialize(String tablesStr, String macroId) {
        try {
            String[] tables = tablesStr.replaceAll("\n", "").replaceAll(" ", "").replaceAll("\\}\\{", "}SEPARATOR{").split("SEPARATOR");
            for (int i = 0; i < tables.length; ++i) {
                String table = tables[i];
                if (macroId != null && !table.contains(macroId)) continue;
                return (T)((Table)this.mapper.readValue(table, this.getTableClass()));
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Error deserializing " + tablesStr, (Throwable)e);
            }
            log.error("Error deserializing " + tablesStr);
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        this.mapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector(this.mapper.getTypeFactory());
        this.mapper.setAnnotationIntrospector(introspector);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

