/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage.action;

import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.boards.events.ListCustomSpaceListViewEvent;
import com.comalatech.confluence.adhoclists.boards.events.SpaceLastAccessEvent;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.lists.ChecklistCreator;
import com.comalatech.confluence.adhoclists.lists.ChecklistRenderer;
import com.comalatech.confluence.adhoclists.lists.model.Checklist;
import com.comalatech.confluence.adhoclists.lists.model.ChecklistViewContext;
import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.model.TableViewContext;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.comalatech.confluence.adhoclists.storage.AdhocListManager;
import com.comalatech.confluence.adhoclists.storage.action.AbstractSpaceTableAction;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceChecklistsAction
extends AbstractSpaceTableAction {
    private static final Logger log = LoggerFactory.getLogger(SpaceChecklistsAction.class);
    protected Checklist checklist;
    protected ChecklistViewContext viewContext;
    protected String renderedChecklistHtml;
    protected AdhocListManager adhocListManager;
    protected ChecklistCreator checklistCreator;
    protected ChecklistRenderer checklistRenderer;
    protected GlobalConfigManager globalConfigManager;
    protected FilterManager filterManager;
    private EventPublisher eventPublisher;

    public String execute() throws Exception {
        if (this.type == null) {
            this.type = AbstractSpaceTableAction.Type.POPULAR_LABELS;
        }
        try {
            if (this.type.equals((Object)AbstractSpaceTableAction.Type.CUSTOM)) {
                this.eventPublisher.publish((Object)new ListCustomSpaceListViewEvent());
            }
            this.checklist = this.makeChecklist();
            this.viewContext = this.makeViewContext(this.checklist);
            Filter filter = this.filterManager.get(this.getSpaceKey(), this.checklist);
            this.renderedChecklistHtml = this.checklistRenderer.renderChecklist(this.viewContext, this.checklist, filter);
        }
        catch (AdhocListsException e) {
            if (log.isDebugEnabled()) {
                log.error("", (Throwable)e);
            } else {
                log.error(e.getMessage());
            }
            if (this.checklist == null) {
                this.checklist = new Checklist(HtmlUtil.urlDecode((String)this.name));
            }
            this.viewContext = this.makeViewContext(this.checklist);
            this.renderedChecklistHtml = this.checklistRenderer.renderChecklist(this.viewContext, this.checklist, e);
        }
        this.eventPublisher.publish((Object)new SpaceLastAccessEvent());
        return "success";
    }

    public String doManage() throws Exception {
        return this.execute();
    }

    private ChecklistViewContext makeViewContext(Checklist checklist) {
        int start = 0;
        int max = AdhocListsUtils.retrieveMaximumRowsForList(this.globalConfigManager, checklist.getMaxRows(), this.getLicenseManager().isLicensed());
        ChecklistViewContext context = new ChecklistViewContext(this.getSpaceKey(), start, max);
        if (this.type == AbstractSpaceTableAction.Type.CUSTOM) {
            if (this.isCanAdmin()) {
                context.addAction(TableViewContext.Action.EDIT);
                context.addAction(TableViewContext.Action.DELETE);
            }
        } else if (this.type == AbstractSpaceTableAction.Type.POPULAR_LABELS && this.isCanAdmin()) {
            context.addAction(TableViewContext.Action.COPY);
        }
        context.setType(this.type.name);
        context.setReadOnly(!this.isCanAdmin());
        context.setSpaceView(true);
        return context;
    }

    public Checklist makeChecklist() throws AdhocListsException {
        if (this.type == AbstractSpaceTableAction.Type.POPULAR_LABELS) {
            return this.checklistCreator.createPopularLabelsChecklist(this.getSpaceKey());
        }
        Checklist checklist = (Checklist)this.adhocListManager.get(this.getSpaceKey(), HtmlUtil.urlDecode((String)this.name));
        if (checklist == null) {
            throw new AdhocListsException("Could not find checklist " + this.name);
        }
        return checklist;
    }

    public List<AbstractSpaceTableAction.NamedTable> getChecklists() {
        ArrayList<AbstractSpaceTableAction.NamedTable> tables = new ArrayList<AbstractSpaceTableAction.NamedTable>();
        tables.add(new AbstractSpaceTableAction.NamedTable(this.getText("adhoclists.checklists.space.default.labels"), AbstractSpaceTableAction.Type.POPULAR_LABELS, this.type == AbstractSpaceTableAction.Type.POPULAR_LABELS));
        String spaceKey = this.getSpaceKey();
        for (String checklistName : this.adhocListManager.getNames(spaceKey)) {
            tables.add(new AbstractSpaceTableAction.NamedTable(spaceKey, checklistName, AbstractSpaceTableAction.Type.CUSTOM, checklistName.equals(HtmlUtil.urlDecode((String)this.name))));
        }
        for (AbstractSpaceTableAction.NamedTable table : tables) {
            if (!table.isCurrent()) continue;
            this.currentTable = table;
            break;
        }
        return tables;
    }

    public void setAdhocListManager(AdhocListManager adhocListManager) {
        this.adhocListManager = adhocListManager;
    }

    public Checklist getChecklist() {
        return this.checklist;
    }

    public ChecklistViewContext getViewContext() {
        return this.viewContext;
    }

    public void setChecklistCreator(ChecklistCreator checklistCreator) {
        this.checklistCreator = checklistCreator;
    }

    public void setChecklistRenderer(ChecklistRenderer checklistRenderer) {
        this.checklistRenderer = checklistRenderer;
    }

    public String getRenderedChecklistHtml() {
        return this.renderedChecklistHtml;
    }

    public void setGlobalConfigManager(GlobalConfigManager globalConfigManager) {
        this.globalConfigManager = globalConfigManager;
    }

    public void setFilterManager(FilterManager filterManager) {
        this.filterManager = filterManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

