/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage;

import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoclists.storage.TableModuleDescriptor;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardSerializer;
import com.comalatech.confluence.boards.model.Board;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class BoardModuleDescriptor
extends TableModuleDescriptor<Board> {
    private static final Logger log = LoggerFactory.getLogger(BoardModuleDescriptor.class);
    private final BoardSerializer boardXmlSerializer;
    private final BoardSerializer boardJsonSerializer;

    public BoardModuleDescriptor(@Qualifier(value="boardXmlSerializer") BoardSerializer boardXmlSerializer, @Qualifier(value="boardJsonSerializer") BoardSerializer boardJsonSerializer, @ComponentImport ModuleFactory moduleFactory) {
        super(moduleFactory);
        this.boardXmlSerializer = boardXmlSerializer;
        this.boardJsonSerializer = boardJsonSerializer;
    }

    @Override
    protected Board deserialize(String body) {
        if (this.format != null && this.format.toLowerCase().contains("json")) {
            return (Board)this.boardJsonSerializer.deserialize(body);
        }
        return (Board)this.boardXmlSerializer.deserialize(body);
    }
}

