/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.util.ArrayList;
import java.util.List;

public class TableViewContext {
    private final String spaceKey;
    private final List<Action> actions;
    private String type;
    private boolean preview;
    protected AbstractPage page;
    private boolean readOnly;

    public TableViewContext(String spaceKey) {
        this.spaceKey = spaceKey;
        this.actions = new ArrayList<Action>();
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void setPage(AbstractPage page) {
        this.page = page;
    }

    public boolean isReadOnly() {
        return this.readOnly || this.preview;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public static enum Action {
        EDIT("edit", ComalaI18nBean.getComalaI18nBean().getText("adhoclists.edit")),
        DELETE("delete", ComalaI18nBean.getComalaI18nBean().getText("adhoclists.delete")),
        COPY("edit", ComalaI18nBean.getComalaI18nBean().getText("adhoclists.copy"));

        private final String name;
        private final String caption;

        private Action(String name, String caption) {
            this.name = name;
            this.caption = caption;
        }

        public String getName() {
            return this.name;
        }

        public String getCaption() {
            return this.caption;
        }
    }
}

