/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.model.BoardLabel;
import com.comalatech.confluence.adhoclists.model.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ResolvedFilter
extends Filter {
    private List<BoardLabel> labelsList;
    private Page parentPage;

    public ResolvedFilter() {
        this.labelsList = new ArrayList<BoardLabel>();
    }

    public ResolvedFilter(List<String> labels, Page parent) {
        super(labels);
        this.parentPage = parent;
        this.setLabelsList(labels);
    }

    public ResolvedFilter(Filter filter) {
        this.setLabels(filter.getLabels());
        this.setParent(filter.getParent());
        this.setDepth(filter.getDepth());
        this.setSpaceKey(filter.getSpaceKey());
        this.setLabelsList(filter.getLabels());
        this.setAllSpaces(filter.isAllSpaces());
    }

    public ResolvedFilter(Filter filter, Page parentPage) {
        this.setLabels(filter.getLabels());
        this.setParent(filter.getParent());
        this.setDepth(filter.getDepth());
        this.setSpaceKey(filter.getSpaceKey());
        this.setLabelsList(filter.getLabels());
        this.setAllSpaces(filter.isAllSpaces());
        this.setParentPage(parentPage);
    }

    public void setLabelsList(List<String> labels) {
        this.setLabels(labels);
        this.labelsList = new ArrayList<BoardLabel>(labels.size());
        for (String label : labels) {
            String labelName = label.startsWith("!") ? label.substring(1) : label;
            ParsedLabelName parsedLabel = LabelParser.parse((String)labelName, (User)AuthenticatedUserThreadLocal.get());
            if (parsedLabel == null) continue;
            this.labelsList.add(new BoardLabel(labelName, label.startsWith("!")));
        }
    }

    public boolean containsLabels(AbstractPage abstractPage) {
        if (this.getLabels().isEmpty()) {
            return true;
        }
        List pageLabels = abstractPage.getLabels();
        List pageLabelNames = pageLabels.stream().map(Label::getName).collect(Collectors.toList());
        for (BoardLabel label : this.labelsList) {
            if ((label.isNegated() || pageLabelNames.contains(label.getName())) && (!label.isNegated() || !pageLabelNames.contains(label.getName()))) continue;
            return false;
        }
        return true;
    }

    public List<BoardLabel> getLabelsList() {
        return this.labelsList;
    }

    public Page getParentPage() {
        return this.parentPage;
    }

    public void setParentPage(Page parentPage) {
        this.parentPage = parentPage;
    }
}

