/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.filter;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.model.TableViewContext;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultFilterManager
implements FilterManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultFilterManager.class);
    private static final int MAX_SUGGESTED_LABELS = 20;
    private final LabelManager labelManager;
    private final BandanaManager bandanaManager;
    private final PageManager pageManager;
    private JAXBContext context;

    public DefaultFilterManager(@ComponentImport LabelManager labelManager, @ComponentImport BandanaManager bandanaManager, @ComponentImport PageManager pageManager) {
        this.labelManager = labelManager;
        this.bandanaManager = bandanaManager;
        this.pageManager = pageManager;
    }

    @Override
    public List<String> getSuggestedLabels(String spaceKey, List<String> excludeLabels) {
        HashSet<String> exclude = new HashSet<String>();
        if (excludeLabels != null) {
            exclude.addAll(excludeLabels);
        }
        List popularLabels = this.labelManager.getMostPopularLabelsInSpace(spaceKey, 20);
        ArrayList<String> suggestedLabels = new ArrayList<String>(popularLabels.size());
        for (LabelSearchResult popularLabel : popularLabels) {
            if (exclude.contains(popularLabel.getLabel().getName())) continue;
            suggestedLabels.add(popularLabel.getLabel().getName());
        }
        return suggestedLabels;
    }

    @Override
    public void save(String spaceKey, Table table, Filter filter) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), this.makeFilterKey(table), (Object)this.serialize(filter));
    }

    @Override
    public Filter get(String spaceKey, Table table) {
        String filterAsString = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), this.makeFilterKey(table));
        if (!StringUtils.isNotBlank((CharSequence)filterAsString)) {
            return new Filter();
        }
        Filter filter = this.deserialize(filterAsString);
        return Objects.requireNonNullElseGet(filter, Filter::new);
    }

    @Override
    public ResolvedFilter resolve(Filter filter, TableViewContext viewContext) {
        ResolvedFilter resolvedFilter = new ResolvedFilter(filter);
        if (!filter.isAllSpaces()) {
            if (filter.isChildPagesOnly() && viewContext.getPage() != null && viewContext.getPage() instanceof Page) {
                resolvedFilter.setParentPage((Page)viewContext.getPage());
            } else if (StringUtils.isNotBlank((CharSequence)filter.getParent())) {
                Page parentPage;
                String spaceKey = StringUtils.isNotBlank((CharSequence)filter.getSpaceKey()) ? filter.getSpaceKey() : viewContext.getSpaceKey();
                try {
                    parentPage = this.pageManager.getPage(Long.parseLong(filter.getParent()));
                }
                catch (Exception e) {
                    parentPage = this.pageManager.getPage(spaceKey, filter.getParent());
                }
                if (parentPage != null) {
                    resolvedFilter.setParentPage(parentPage);
                } else if (!filter.isChildPagesOnly()) {
                    Page fakeParent = new Page();
                    fakeParent.setId(-1L);
                    resolvedFilter.setParentPage(fakeParent);
                }
            }
        }
        return resolvedFilter;
    }

    private String serialize(Filter filter) {
        try {
            this.initJAXBContext();
            Marshaller marshaller = this.context.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)filter, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    private Filter deserialize(String filter) {
        try {
            this.initJAXBContext();
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            StringReader reader = new StringReader(filter);
            return (Filter)unmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    private String makeFilterKey(Table table) {
        XmlRootElement annotation = table.getClass().getAnnotation(XmlRootElement.class);
        return "com.comalatech.adhoclists.filter." + annotation.name() + "." + table.getName();
    }

    private void initJAXBContext() throws JAXBException {
        if (this.context == null) {
            this.context = JAXBContext.newInstance((Class[])new Class[]{Filter.class});
        }
    }
}

