/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.condition;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.plugin.PluginParseException;
import com.comalatech.confluence.adhoclists.model.GlobalConfig;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AllowedInSpaceCondition
extends BaseConfluenceCondition {
    private GlobalConfigManager globalConfigManager;
    private String item;

    public AllowedInSpaceCondition(GlobalConfigManager globalConfigManager) {
        this.globalConfigManager = globalConfigManager;
    }

    public boolean shouldDisplay(WebInterfaceContext context) {
        if (context.getSpace() == null) {
            return false;
        }
        String spaceKey = context.getSpace().getKey();
        String spacesShow = this.getGlobalConfig().getShowHideMap().get(this.getShowKey());
        String spacesHide = this.getGlobalConfig().getShowHideMap().get(this.getHideKey());
        for (String hide : spacesHide.split(",\\s*")) {
            if (hide.trim().equalsIgnoreCase("any")) {
                return false;
            }
            if (!hide.trim().equalsIgnoreCase(spaceKey)) continue;
            return false;
        }
        for (String show : spacesShow.split(",\\s*")) {
            if (show.trim().equalsIgnoreCase("any")) {
                return true;
            }
            if (!show.trim().equalsIgnoreCase(spaceKey)) continue;
            return true;
        }
        return false;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.item = params.get("item");
        if (!StringUtils.isNotBlank((CharSequence)this.item)) {
            throw new PluginParseException("Condition not initialised to board or list");
        }
        if (this.item.toLowerCase().contains("board")) {
            this.item = "board";
            return;
        }
        if (this.item.toLowerCase().contains("list")) {
            this.item = "list";
            return;
        }
        throw new PluginParseException("Condition not initialised to board or list");
    }

    private GlobalConfig getGlobalConfig() {
        return this.globalConfigManager.loadGlobalConfig();
    }

    private String getHideKey() {
        if (this.item.equals("list")) {
            return ".hideListSpaces";
        }
        return ".hideBoardSpaces";
    }

    private String getShowKey() {
        if (this.item.equals("list")) {
            return ".showListSpaces";
        }
        return ".showBoardSpaces";
    }

    public AllowedInSpaceCondition setItem(String item) {
        this.item = item;
        return this;
    }
}

