/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards.view;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.adhoclists.boards.view.AbstractBoardResolver;
import com.comalatech.confluence.adhoclists.boards.view.BoardResolver;
import com.comalatech.confluence.adhoclists.boards.view.model.RenderedCard;
import com.comalatech.confluence.adhoclists.boards.view.model.ResolvedContainer;
import com.comalatech.confluence.adhoclists.cards.CardManager;
import com.comalatech.confluence.adhoclists.cards.model.Cards;
import com.comalatech.confluence.adhoclists.cards.model.ResolvedCard;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import com.comalatech.confluence.boards.model.BoardViewContext;
import com.comalatech.confluence.boards.model.Container;
import com.comalatech.confluence.boards.model.LabelContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LabelBoardResolver
extends AbstractBoardResolver
implements BoardResolver {
    private static final Logger log = LoggerFactory.getLogger(LabelBoardResolver.class);
    private final int CQL_MAX_RESULTS = AdhocListsUtils.getSystemMaxPageResults();
    private final PageManager pageManager;
    private final CardManager cardManager;
    private final CQLSearchService cqlSearchService;

    public LabelBoardResolver(@ComponentImport PermissionManager permissionManager, @ComponentImport WikiStyleRenderer wikiStyleRenderer, @ComponentImport PageManager pageManager, CardManager cardManager, @ComponentImport CQLSearchService cqlSearchService) {
        super(permissionManager, wikiStyleRenderer);
        this.pageManager = pageManager;
        this.cardManager = cardManager;
        this.cqlSearchService = cqlSearchService;
    }

    @Override
    public ResolvedContainer getExpandedContainer(BoardViewContext viewContext, ResolvedFilter filter, Container container, int start) {
        ResolvedContainer resolvedContainer = new ResolvedContainer(container);
        resolvedContainer.setDescriptionHtml(this.renderDescription(container.getDescription()));
        if (viewContext.isHistoricalPageVersion()) {
            return resolvedContainer;
        }
        return this.getPagesByLabel(viewContext, resolvedContainer, filter, start);
    }

    private ResolvedContainer getPagesByLabel(BoardViewContext viewContext, ResolvedContainer container, ResolvedFilter filter, int start) {
        if (filter.isAllSpaces()) {
            return this.getPagesInSpacesByLabel(viewContext, container, filter, start);
        }
        if (filter.getParentPage() != null) {
            return this.getChildPagesByLabel(viewContext, container, filter, start);
        }
        return this.getPagesInSpacesByLabel(viewContext, container, filter, start);
    }

    private ResolvedContainer getChildPagesByLabel(BoardViewContext boardViewContext, ResolvedContainer container, ResolvedFilter filter, int start) {
        ArrayList<RenderedCard> renderedCards = new ArrayList();
        int processedCards = 0;
        int ix = 0;
        int maximumCardsToDisplay = boardViewContext.getCount();
        ContainerSieve sieve = new ContainerSieve(boardViewContext, container.getLabels(), filter);
        List<Page> allPages = this.getFirstBatchOfChildPages(sieve);
        if (StringUtils.isNotBlank((CharSequence)container.getKey())) {
            if (boardViewContext.getPage() != null) {
                List<ResolvedCard> allEntities = allPages.stream().map(page -> new RenderedCard((AbstractPage)page, sieve.isVisible((ContentEntityObject)page))).collect(Collectors.toList());
                Cards cards = this.cardManager.getCards((ContentEntityObject)boardViewContext.getPage(), container.getKey());
                cards.synchronize(allEntities);
                ArrayList<ResolvedCard> newCards = new ArrayList<ResolvedCard>(cards.getResolved());
                for (ResolvedCard card : newCards) {
                    RenderedCard renderedCard = this.getRenderedCardFromResolvedCard(boardViewContext, card);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("add card '%s' to container '%s' on page '%s'", renderedCard.getTitle(), container.getLabels(), boardViewContext.getPage().getTitle()));
                    }
                    if (!renderedCard.isVisible() || ix++ < start) continue;
                    if (processedCards >= boardViewContext.getCount()) {
                        container.setHasMoreEntities(true);
                        break;
                    }
                    renderedCard.setReadOnly(!sieve.isEditable(renderedCard.getContentEntityObject()));
                    renderedCards.add(renderedCard);
                    ++processedCards;
                }
                if (cards.isDirty()) {
                    this.cardManager.saveCards((ContentEntityObject)boardViewContext.getPage(), container.getKey(), cards);
                }
            } else {
                for (Page page2 : allPages) {
                    RenderedCard entity;
                    if (processedCards >= maximumCardsToDisplay) {
                        container.setHasMoreEntities(true);
                        break;
                    }
                    entity.setReadOnly(!sieve.isEditable((entity = new RenderedCard((AbstractPage)page2)).getContentEntityObject()));
                    renderedCards.add(entity);
                    ++processedCards;
                }
            }
        } else {
            renderedCards = this.populateEmptyContainer(container, filter, start, sieve, boardViewContext, allPages);
        }
        container.setEntities(renderedCards);
        return container;
    }

    private List<Page> getFirstBatchOfChildPages(ContainerSieve sieve) {
        Page filterParent = sieve.parentFilter;
        StringBuffer cqlQuery = new StringBuffer("type = page AND ancestor = " + filterParent.getIdAsString());
        cqlQuery.append(this.createQuery(sieve.allLabels, labels -> !labels.isEmpty(), () -> " AND space.key = \"" + sieve.spaceKey + "\"" + this.generateLabelPredicate(sieve.allLabels)));
        return this.getPagesWithCql(cqlQuery.toString(), sieve.filter);
    }

    private List<Page> getPagesWithCql(String cqlQuery, ResolvedFilter filter) {
        ArrayList<Page> pages = new ArrayList<Page>();
        int depth = filter.getDepth();
        try {
            if (depth == 0 || filter.getParentPage() == null) {
                PageResponse pageResponse;
                do {
                    pageResponse = this.cqlSearchService.searchContent(cqlQuery, (PageRequest)new SimplePageRequest(pages.size(), 500), new Expansion[0]);
                    ArrayList<Long> contentIds = new ArrayList<Long>();
                    for (Content content : pageResponse.getResults()) {
                        contentIds.add(content.getId().asLong());
                    }
                    pages.addAll(this.pageManager.getPages(contentIds));
                } while (pageResponse != null && pageResponse.hasMore() && pages.size() < this.CQL_MAX_RESULTS);
            } else if (depth > 0) {
                PageResponse pageResponse;
                do {
                    pageResponse = this.cqlSearchService.searchContent(cqlQuery, (PageRequest)new SimplePageRequest(pages.size(), 500), new Expansion[]{new Expansion("ancestors")});
                    int effectiveDepth = filter.getParentPage() != null && filter.getParentPage().getAncestors() != null ? depth + filter.getParentPage().getAncestors().size() : depth;
                    ArrayList<Long> contentIds = new ArrayList<Long>();
                    for (Content content : pageResponse.getResults()) {
                        if (effectiveDepth < content.getAncestors().size()) continue;
                        contentIds.add(content.getId().asLong());
                    }
                    pages.addAll(this.pageManager.getPages(contentIds));
                } while (pageResponse != null && pageResponse.hasMore() && pages.size() < this.CQL_MAX_RESULTS);
            }
        }
        catch (Exception e) {
            log.error("There was an error executing CQL: " + cqlQuery + " with filter: " + filter, (Throwable)e);
        }
        return pages;
    }

    private ResolvedContainer getPagesInSpacesByLabel(BoardViewContext viewContext, ResolvedContainer container, ResolvedFilter filter, int start) {
        String spaceKey;
        ArrayList<RenderedCard> renderedCards = new ArrayList();
        ContainerSieve sieve = new ContainerSieve(viewContext, new LabelContainer(container).getPageLabelList(), filter.isAllSpaces() ? new ResolvedFilter() : filter);
        String string = spaceKey = StringUtils.isNotBlank((CharSequence)filter.getSpaceKey()) ? filter.getSpaceKey() : viewContext.getSpaceKey();
        if (StringUtils.isNotBlank((CharSequence)container.getKey())) {
            List<ResolvedCard> entities;
            String cqlQuery = "type = page " + this.generateLabelPredicate(sieve.allLabels);
            cqlQuery = cqlQuery + this.createQuery(filter, f -> !f.isAllSpaces(), () -> " AND space.key = \"" + spaceKey + "\"");
            List<ResolvedCard> sortedEntities = entities = this.getPagesWithCql(cqlQuery, filter).stream().map(page -> new RenderedCard((AbstractPage)page, sieve.isVisible((ContentEntityObject)page))).collect(Collectors.toList());
            Cards cards = null;
            if (viewContext.getPage() != null) {
                cards = this.cardManager.getCards((ContentEntityObject)viewContext.getPage(), container.getKey());
                cards.synchronize(entities);
                sortedEntities = cards.getResolved();
            }
            int ix = 0;
            int processedCards = 0;
            int maximumCardsToDisplay = viewContext.getCount();
            for (ResolvedCard resolvedCard : sortedEntities) {
                RenderedCard renderedCard = this.getRenderedCardFromResolvedCard(viewContext, resolvedCard);
                if (!renderedCard.isVisible()) continue;
                if (ix >= start) {
                    if (processedCards++ < maximumCardsToDisplay) {
                        renderedCard.setReadOnly(!sieve.isEditable(renderedCard.getContentEntityObject()));
                        renderedCards.add(renderedCard);
                    } else {
                        container.setHasMoreEntities(true);
                        break;
                    }
                }
                ++ix;
            }
            if (cards != null && cards.isDirty()) {
                this.cardManager.saveCards((ContentEntityObject)viewContext.getPage(), container.getKey(), cards);
            }
        } else {
            String cqlQuery = "type = page AND space.key = \"" + spaceKey + "\"";
            List<Page> spacePages = this.getPagesWithCql(cqlQuery, filter);
            renderedCards = this.populateEmptyContainer(container, filter, start, sieve, viewContext, spacePages);
        }
        container.setEntities(renderedCards);
        return container;
    }

    public RenderedCard makeRenderedCard(AbstractPage page, ResolvedCard card) {
        RenderedCard renderedCard = new RenderedCard(card);
        renderedCard.setBodyHtml(this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)page.toPageContext(), card.getBody()));
        if (card.getContent() != null && !card.getContent().isEmpty()) {
            renderedCard.setContentHtml(this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)page.toPageContext(), card.getContent()));
        }
        return renderedCard;
    }

    private List<RenderedCard> populateEmptyContainer(ResolvedContainer container, ResolvedFilter filter, int start, ContainerSieve sieve, BoardViewContext viewContext, List<Page> spacePages) {
        List<ResolvedCard> sortedEntities;
        ConfluenceUser user = sieve.user;
        boolean admin = sieve.isAdmin;
        List<Label> allBoardLabels = viewContext.getAllLabels();
        ArrayList<ResolvedCard> entities = new ArrayList<ResolvedCard>();
        for (Page page : spacePages) {
            boolean found = allBoardLabels.stream().anyMatch(page.getLabels()::contains);
            if (found || !filter.containsLabels((AbstractPage)page) || !admin && !this.canView(user, (ContentEntityObject)page)) continue;
            RenderedCard renderedCard = new RenderedCard((AbstractPage)page);
            renderedCard.setReadOnly(!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)page));
            entities.add(renderedCard);
        }
        Cards cards = null;
        if (viewContext.getPage() != null) {
            cards = this.cardManager.getCards((ContentEntityObject)viewContext.getPage(), container.getKey());
            cards.synchronize(entities);
            sortedEntities = cards.getResolved();
        } else {
            sortedEntities = entities;
        }
        ArrayList<RenderedCard> renderedCards = new ArrayList<RenderedCard>();
        int ix = 0;
        int read = 0;
        for (ResolvedCard card : sortedEntities) {
            RenderedCard renderedCard = this.getRenderedCardFromResolvedCard(viewContext, card);
            if (!renderedCard.isVisible()) continue;
            if (ix >= start) {
                if (read++ < viewContext.getCount()) {
                    renderedCard.setReadOnly(!sieve.isEditable(renderedCard.getContentEntityObject()));
                    renderedCards.add(renderedCard);
                } else {
                    container.setHasMoreEntities(true);
                    break;
                }
            }
            ++ix;
        }
        if (cards != null && cards.isDirty()) {
            this.cardManager.saveCards((ContentEntityObject)viewContext.getPage(), container.getKey(), cards);
        }
        return renderedCards;
    }

    private RenderedCard getRenderedCardFromResolvedCard(BoardViewContext viewContext, ResolvedCard card) {
        if (card instanceof RenderedCard) {
            return (RenderedCard)card;
        }
        return this.makeRenderedCard(viewContext.getPage(), card);
    }

    private <T> String createQuery(T testObject, Predicate<T> filter, Supplier<String> query) {
        if (filter.test(testObject)) {
            return query.get();
        }
        return "";
    }

    private String generateLabelPredicate(List<Label> predicates) {
        StringBuilder condition = new StringBuilder();
        for (Label predicate : predicates) {
            condition.append(" AND label = \"" + predicate.toString() + "\"");
        }
        return condition.toString();
    }

    class ContainerSieve {
        ResolvedFilter filter;
        List<Label> allLabels;
        ConfluenceUser user;
        boolean isAdmin;
        boolean readOnly;
        boolean noLabelsLeftToFilter;
        Page parentFilter;
        String spaceKey;
        BoardViewContext viewContext;

        ContainerSieve(BoardViewContext viewContext, List<Label> labels, ResolvedFilter filter) {
            this.filter = filter;
            this.viewContext = viewContext;
            this.allLabels = new ArrayList<Label>(labels);
            this.allLabels.addAll(filter.getLabelsList());
            this.noLabelsLeftToFilter = this.allLabels.isEmpty();
            this.user = AuthenticatedUserThreadLocal.get();
            this.isAdmin = LabelBoardResolver.this.isAdmin(this.user);
            this.readOnly = viewContext.isReadOnly();
            this.parentFilter = filter.getParentPage();
            this.spaceKey = filter.getSpaceKey();
            if (!StringUtils.isNotBlank((CharSequence)this.spaceKey) && this.parentFilter != null) {
                this.spaceKey = this.parentFilter.getSpaceKey();
            }
            if (!StringUtils.isNotBlank((CharSequence)this.spaceKey)) {
                this.spaceKey = viewContext.getSpaceKey();
            }
        }

        boolean isVisible(ContentEntityObject ceo) {
            return this.isAdmin || LabelBoardResolver.this.canView(this.user, ceo);
        }

        boolean isEditable(ContentEntityObject ceo) {
            return this.isAdmin || !this.readOnly && (ceo == null || LabelBoardResolver.this.permissionManager.hasPermission(this.user, Permission.EDIT, (Object)ceo) && LabelBoardResolver.this.permissionManager.hasPermission(this.user, Permission.EDIT, (Object)this.viewContext.getPage()));
        }
    }
}

