/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards.listeners;

import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.boards.events.CardMovedOnBoardEvent;
import com.comalatech.confluence.adhoclists.boards.events.CardUpdatedEvent;
import com.comalatech.confluence.adhoclists.boards.events.TaskCardUsedEvent;
import com.comalatech.confluence.adhoclists.boards.notification.AdhocCanvasNotificationService;
import com.comalatech.confluence.adhoclists.cards.model.Card;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CardMovedNotificationListener
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(CardMovedNotificationListener.class);
    private final EventPublisher eventPublisher;
    private final AdhocCanvasNotificationService adhocCanvasNotificationService;
    private final GlobalConfigManager globalConfigManager;
    private final NotificationManager notificationManager;
    private final UserAccessor userAccessor;
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final I18nResolver i18nResolver;
    private final GlobalSettingsManager settingsManager;
    private final HostApplication hostApplication;

    public CardMovedNotificationListener(@ComponentImport EventPublisher eventPublisher, AdhocCanvasNotificationService adhocCanvasNotificationService, @ComponentImport NotificationManager notificationManager, @ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager settingsManager, @Qualifier(value="hostApplication") @ComponentImport HostApplication hostApplication, GlobalConfigManager globalConfigManager, @ComponentImport PermissionManager permissionManager) {
        this.eventPublisher = eventPublisher;
        this.adhocCanvasNotificationService = adhocCanvasNotificationService;
        this.notificationManager = notificationManager;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.i18nResolver = i18nResolver;
        this.settingsManager = settingsManager;
        this.hostApplication = hostApplication;
        this.globalConfigManager = globalConfigManager;
        this.permissionManager = permissionManager;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void cardMoved(CardMovedOnBoardEvent event) {
        if (event.getToKey().equals(event.getFromKey())) {
            return;
        }
        this.eventPublisher.publish((Object)new CardUpdatedEvent());
        if (StringUtils.contains((CharSequence)event.getToKey(), (CharSequence)"@") && StringUtils.contains((CharSequence)event.getFromKey(), (CharSequence)"@")) {
            this.eventPublisher.publish((Object)new TaskCardUsedEvent());
        }
        Set<ConfluenceUser> watchers = this.getWatchers(event);
        HashSet<ConfluenceUser> notifiedUsers = new HashSet<ConfluenceUser>(watchers);
        notifiedUsers.addAll(this.getUsersFromKey(event.getToKey()));
        Set<ConfluenceUser> permittedUsers = this.filterPermittedUsers(event, notifiedUsers);
        if (!permittedUsers.isEmpty()) {
            Map<ConfluenceUser, com.atlassian.mywork.model.Notification> myworkNotifications = this.buildMyworkNotifications(event, new ArrayList<ConfluenceUser>(permittedUsers));
            this.adhocCanvasNotificationService.sendNotifications(myworkNotifications);
        }
    }

    private Set<ConfluenceUser> filterPermittedUsers(CardMovedOnBoardEvent event, Set<ConfluenceUser> notifiedUsers) {
        HashSet<ConfluenceUser> allowedUsers = new HashSet<ConfluenceUser>();
        AbstractPage movingPage = this.getPageFromCard(event.getCard());
        for (ConfluenceUser user : notifiedUsers) {
            boolean shouldInclude = true;
            if (movingPage != null) {
                shouldInclude = this.permissionManager.hasPermission(user, Permission.VIEW, (Object)movingPage);
            }
            if (!shouldInclude || !this.permissionManager.hasPermission(user, Permission.VIEW, (Object)event.getContainingObject())) continue;
            allowedUsers.add(user);
        }
        return allowedUsers;
    }

    private Set<ConfluenceUser> getWatchers(CardMovedOnBoardEvent event) {
        HashSet<ConfluenceUser> watchers = new HashSet<ConfluenceUser>();
        if (!event.isNotify() || event.getFromKey() == null) {
            return watchers;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        List notifications = this.notificationManager.getNotificationsByContent(event.getContainingObject());
        for (Notification n : notifications) {
            if (n.getContent() == null || n.getReceiver() == null || !this.validateUsers(n.getReceiver().getName(), currentUser)) continue;
            watchers.add(this.userAccessor.getUserByName(n.getReceiver().getName()));
        }
        return watchers;
    }

    private Set<ConfluenceUser> getUsersFromKey(String toKey) {
        String currentUserName = AuthenticatedUserThreadLocal.getUsername();
        HashSet<ConfluenceUser> users = new HashSet<ConfluenceUser>();
        for (Label label : AdhocListsUtils.toLabelList(toKey)) {
            ConfluenceUser user;
            if (label.getNamespace() != Namespace.PERSONAL || (user = label.getOwnerUser()) == null || !this.validateUsers(currentUserName, user)) continue;
            users.add(user);
        }
        return users;
    }

    private boolean validateUsers(String currentUserName, ConfluenceUser user) {
        return !user.getName().equals(currentUserName) || this.globalConfigManager.loadGlobalConfig().isNotifyOwnChanges();
    }

    private AbstractPage getPageFromCard(Card card) {
        if (StringUtils.isNotBlank((CharSequence)card.getId())) {
            try {
                return this.pageManager.getAbstractPage(Long.parseLong(card.getId()));
            }
            catch (NumberFormatException nfe) {
                log.error("Error getting the content with id: " + card.getId());
            }
        }
        return null;
    }

    private Map<ConfluenceUser, com.atlassian.mywork.model.Notification> buildMyworkNotifications(CardMovedOnBoardEvent event, List<ConfluenceUser> watchers) {
        HashMap<ConfluenceUser, com.atlassian.mywork.model.Notification> notifications = new HashMap<ConfluenceUser, com.atlassian.mywork.model.Notification>();
        String itemIconUrl = this.settingsManager.getGlobalSettings().getBaseUrl() + "/download/resources/com.comalatech.adhoccanvas:boardresources/images/comalacanvas16.png";
        CardsMovedEventMessage message = new CardsMovedEventMessage(event);
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        for (ConfluenceUser user : watchers) {
            String cardAction = event.getFromKey() != null ? "cardmoved" : "cardadded";
            com.atlassian.mywork.model.Notification notification = new NotificationBuilder().application("com.comalatech.adhoccanvas.mywork").title(message.title).itemTitle(message.itemTitle).itemUrl(this.settingsManager.getGlobalSettings().getBaseUrl() + event.getContainingObject().getUrlPath()).itemIconUrl(itemIconUrl).description(message.description).entity("board").action(cardAction).globalId("appId=" + this.hostApplication.getId().get() + "entity=board&id=" + new Date().getTime()).iconUrl(this.getUserAvatarUrl(currentUser)).applicationLinkId(this.hostApplication.getId().get()).createNotification();
            notifications.put(user, notification);
        }
        return notifications;
    }

    protected String getUserAvatarUrl(ConfluenceUser user) {
        String pictureUrl = "/images/icons/profilepics/default.gif";
        if (user != null) {
            pictureUrl = this.userAccessor.getUserProfilePicture((User)user).getUriReference();
        }
        return this.settingsManager.getGlobalSettings().getBaseUrl() + pictureUrl;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public class CardsMovedEventMessage {
        final String title;
        final String itemTitle;
        final String description;

        public CardsMovedEventMessage(CardMovedOnBoardEvent event) {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            String titleKey = "com.comalatech.adhoccanvas.mywork.board.cardmoved.owntitle";
            if (event.getFromKey() == null) {
                titleKey = "com.comalatech.adhoccanvas.mywork.board.cardadded.owntitle";
            }
            this.title = CardMovedNotificationListener.this.i18nResolver.getText(titleKey, new Serializable[]{currentUser.getFullName(), event.getCard().getTitle(), event.getContainingObject().getTitle()});
            Map<String, String> containerTitles = this.processContainerTitles(event);
            if (event.getCard().getId() != null) {
                if (event.getFromKey() != null) {
                    this.description = CardMovedNotificationListener.this.i18nResolver.getText("adhoccanvas.notification.page.was.moved.from.container.to.container", new Serializable[]{event.getCard().getTitle(), (Serializable)((Object)containerTitles.get("fromTitle")), (Serializable)((Object)containerTitles.get("toTitle"))});
                    this.itemTitle = CardMovedNotificationListener.this.i18nResolver.getText("com.comalatech.adhoccanvas.mywork.board.pagemoved.itemTitle", new Serializable[]{event.getCard().getTitle(), event.getContainingObject().getTitle()});
                } else {
                    this.description = CardMovedNotificationListener.this.i18nResolver.getText("adhoccanvas.notification.page.was.added.to.container", new Serializable[]{event.getCard().getTitle(), (Serializable)((Object)containerTitles.get("toTitle"))});
                    this.itemTitle = CardMovedNotificationListener.this.i18nResolver.getText("com.comalatech.adhoccanvas.mywork.board.pageadded.itemTitle", new Serializable[]{event.getCard().getTitle(), event.getContainingObject().getTitle()});
                }
            } else if (event.getFromKey() != null) {
                this.description = CardMovedNotificationListener.this.i18nResolver.getText("adhoccanvas.notification.card.was.moved.from.container.to.container", new Serializable[]{event.getCard().getTitle(), (Serializable)((Object)containerTitles.get("fromTitle")), (Serializable)((Object)containerTitles.get("toTitle"))});
                this.itemTitle = CardMovedNotificationListener.this.i18nResolver.getText("com.comalatech.adhoccanvas.mywork.board.cardmoved.itemTitle", new Serializable[]{event.getCard().getTitle(), event.getContainingObject().getTitle()});
            } else {
                this.description = CardMovedNotificationListener.this.i18nResolver.getText("adhoccanvas.notification.card.was.added.to.container", new Serializable[]{event.getCard().getTitle(), (Serializable)((Object)containerTitles.get("toTitle"))});
                this.itemTitle = CardMovedNotificationListener.this.i18nResolver.getText("com.comalatech.adhoccanvas.mywork.board.cardadded.itemTitle", new Serializable[]{event.getCard().getTitle(), event.getContainingObject().getTitle()});
            }
        }

        private Map<String, String> processContainerTitles(CardMovedOnBoardEvent event) {
            HashMap<String, String> titles = new HashMap<String, String>();
            titles.put("fromTitle", event.getFromTitle());
            titles.put("toTitle", event.getToTitle());
            for (String key : titles.keySet()) {
                ConfluenceUser user;
                String title = (String)titles.get(key);
                if (!StringUtils.isNotBlank((CharSequence)title) || !title.startsWith("@") || (user = CardMovedNotificationListener.this.userAccessor.getUserByName(title.substring(1))) == null || !StringUtils.isNotBlank((CharSequence)user.getFullName())) continue;
                titles.put(key, user.getFullName());
            }
            return titles;
        }
    }
}

