/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists;

import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.transformer.TransformerParameters;
import com.atlassian.webresource.spi.transformer.TransformerUrlBuilder;
import com.atlassian.webresource.spi.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.webresource.spi.transformer.WebResourceTransformerFactory;
import com.comalatech.confluence.adhoclists.model.Styles;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleTransformer
implements WebResourceTransformerFactory {
    private static final Logger log = LoggerFactory.getLogger(StyleTransformer.class);
    private final VelocityHelperService velocityHelperService;

    public StyleTransformer(@ComponentImport VelocityHelperService velocityHelperService) {
        this.velocityHelperService = velocityHelperService;
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters transformerParameters) {
        return urlBuilder -> {};
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters transformerParameters) {
        return (transformableResource, params) -> new DownloadableResource(){

            public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
                return false;
            }

            public void serveResource(HttpServletRequest request, HttpServletResponse response) {
            }

            public void streamResource(OutputStream out) {
                Map contextMap = MacroUtils.defaultVelocityContext();
                contextMap.put("styles", Styles.getInstance());
                String transformableResourceStream = StyleTransformer.this.velocityHelperService.getRenderedTemplate(transformableResource.location().getLocation(), contextMap);
                try {
                    transformableResourceStream = transformableResourceStream.replace("##.*", "").replaceAll("\\s+", " ");
                    out.write(transformableResourceStream.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException exception) {
                    log.error("Unable to render template", (Throwable)exception);
                }
            }

            public String getContentType() {
                return "text/css";
            }
        };
    }
}

