/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists;

import com.atlassian.confluence.content.render.xhtml.migration.WikiToXhtmlMigrator;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.TableHandler;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;

public class AbstractTableHandler
implements TableHandler,
InitializingBean {
    protected PageManager pageManager;
    protected WikiToXhtmlMigrator wikiToXhtmlMigrator;
    protected ComalaI18nBean comalaI18nBean;

    public AbstractTableHandler(PageManager pageManager, ComalaI18nBean comalaI18nBean) {
        this.pageManager = pageManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    protected void setPageContent(String wiki, AbstractPage page) {
        if (StringUtils.isNotBlank((CharSequence)(wiki = AdhocListsUtils.clean(wiki)))) {
            ArrayList runtimeExceptions = new ArrayList();
            String storage = this.wikiToXhtmlMigrator.migrate(wiki, (RenderContext)page.toPageContext(), runtimeExceptions);
            page.setBodyAsString(storage);
        }
    }

    @Override
    public Page createPageWikiBody(Space space, String pageName, String wikiBody, Page parent) throws AdhocListsException {
        if (!Page.isValidPageTitle((String)pageName)) {
            throw new AdhocListsException(this.comalaI18nBean.getText("adhoclists.boards.card.page.invalid"));
        }
        Page page = new Page();
        if (parent != null) {
            parent.addChild(page);
        }
        page.setTitle(pageName);
        this.setPageContent(wikiBody, (AbstractPage)page);
        page.setSpace(space);
        this.pageManager.saveContentEntity((ContentEntityObject)page, null);
        return page;
    }

    @Override
    public Page createPage(Space space, String pageName, BodyContent content, Page parent) throws AdhocListsException {
        if (!Page.isValidPageTitle((String)pageName)) {
            throw new AdhocListsException(this.comalaI18nBean.getText("adhoclists.boards.card.page.invalid"));
        }
        Page page = new Page();
        if (parent != null) {
            parent.addChild(page);
        }
        page.setTitle(pageName);
        page.setBodyAsString(content.getBody());
        page.setSpace(space);
        this.pageManager.saveContentEntity((ContentEntityObject)page, null);
        return page;
    }

    public void afterPropertiesSet() {
        this.wikiToXhtmlMigrator = (WikiToXhtmlMigrator)ContainerManager.getComponent((String)"wikiToXhtmlMigrator", WikiToXhtmlMigrator.class);
    }
}

