/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Canvas = Canvas || {};
Canvas.Wizard = Canvas.Wizard || {};

Canvas.Wizard.NxMBoard = Backbone.View.extend({
    className: 'cnv-wizard-nxm',

    n: 2, // rows
    m: 2, // columns

    max: 8, // max number of rows and columns

    gridX: 800, // 800 - 240
    gridY: 400, // 400 - 120

    template: Canvas.WizardTemplates.nxmBoard,
    templateUser: Canvas.WizardTemplates.tasksUser,

    board: {
        "type":"LABEL",
        "row":[
            {
                "header":"Row 1",
                "column":[
                    {
                        "header":"Column 1",
                        "container":[{"key":"row1,column1","caption":" ","style":""}]
                    },
                    {
                        "header":"Column 2",
                        "container":[{"key":"row1,column2","caption":" ","style":"s000"}]
                    }
                ]
            },
            {
                "header":"Row 2",
                "column":[
                    {"container":[{"key":"row2,column1","caption":" ","style":"s001"}]},
                    {"container":[{"key":"row2,column2","caption":" ","style":"s002"}]}
                ]
            }
        ],
        "name":"New Board"
    },

    // TODO uncomplete color temperature
    palette: [
        ['s001','s033','s027','s014'],
        ['s026','s003','s018','s007'],

        ['s001','s033','s027','s014'],
        ['s026','s003','s018','s007'],
        ['s001','s033','s027','s014'],
        ['s026','s003','s018','s007']
    ],

    events: {
        "keyup .cnv-n" : "rows",
        "keyup .cnv-m" : "columns",
        "focus .text" : "focus"
        //"mouseover .cnv-wizard-body": "grid"
    },

    initialize: function() {
        this.render();
        this.$error = this.$(".error");
        this.$preview = this.$(".boardPreview");
        //this.$uiStep1 = this.$('.uiguide-step1');
        //this.$uiStep1.fadeIn();
        this.renderPreview(this.board);

        this.cellX = this.gridX / this.max;
        this.cellY = this.gridY / this.max;

        this.$('#rows').focus();
    },

    // experimental
    grid: function (evt) {
        var x = evt.clientX;
        var y = evt.clientY;

        cols = Math.round(x / this.cellX, 0);
        rows = Math.round(y / this.cellY, 0);

        if(cols != this.n || rows != this.m) {
            this.n = cols;
            this.m = rows;
            var board = this.makeBoard();
            this.renderPreview(board.toJSON());
        }

        console.log('grid', x, y, rows, cols, evt);
    },

    focus: function(evt) {
        this.$(evt.target).select();
    },

    // TODO only allow numbers
    rows: function (evt) {
        var val = this.$(evt.target).val();
        
        if(val != '') {
            this.n = this._maxLimit(val);
            this.$(evt.target).val(this.n);

            var board = this.makeBoard();
            this.renderPreview(board.toJSON());
        }
    },

    // TODO only allow numbers
    columns: function (evt) {
        var val = this.$(evt.target).val();

        if(val != '') {
            this.m = this._maxLimit(val);
            this.$(evt.target).val(this.m);

            var board = this.makeBoard();
            this.renderPreview(board.toJSON());
        }
    },

    _maxLimit: function (n) {
        if(n > this.max) {
            n = this.max;
        }
        return n;
    },

    error: function(message) {
        this.$error.html(message);
    },

    renderPreview: function(board) {
        this.$preview.html(Canvas.WizardTemplates.boardPreview({board: board, showCaptions: true}));
    },

    convertToLabel: function(input) {
        var specialCharacter = /[\s:;\.?&\[\]\(\)#\^!<>~\*]+/g; // allowing the @ character deliberately
        var lo = input.toLowerCase();
        return lo.replace(specialCharacter, '')
    },

    makeBoard: function() {
        var rows = [];

        // rows
        for (var i = 0; i < this.n; i++) {
            var cols = [];
            // columns
            for (var j = 0; j < this.m; j++) {
                var style = this.palette[i][j];

                cols.push({
                    "container" : [{
                        "key" : "row" + (i+1) + ",column" + (j+1),
                        "caption" : "",
                        "style" : style
                    }] 
                })
            }
            rows.push({
                "column": cols
            })
        }

        // TODO Remove, only for DEVEL
        boardDEMO = {
            "type":"LABEL",
            "row":[
                {
                    "header":"Row 1",
                    "column":[
                        {
                            "header":"Column 1",
                            "container":[{"key":"row1,column1","caption":" ","style":""}]
                        },
                        {
                            "header":"Column 2",
                            "container":[{"key":"row1,column2","caption":" ","style":"s000"}]
                        }
                    ]
                },
                {
                    "header":"Row 2",
                    "column":[
                        {"container":[{"key":"row2,column1","caption":" ","style":"s001"}]},
                        {"container":[{"key":"row2,column2","caption":" ","style":"s002"}]}
                    ]
                }
            ],
            "name":"New Board"
        };

        var board = new Canvas.Model.Board({
            "name":"New Board",
            "type" : "LABEL",
            "row" : rows
        });

        return board;
    },

    render: function() {
        this.$el.html(this.template({}));
        return this;
    }

});