/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    if (Canvas.initialized("selectlabel.column")) {
        return;
    }

    function isPopulated($row) {
        return $row.find('input').filter(
            function () { return this.value !== ''; }
        ).length > 0
    }

    AJS.toInit(function ($) {
        AJS.log("init selectlabel.column");
        // adding option
        $(document).on('click', "form.aui.checklist.column.selectlabel .addoption", function(event) {
            event.preventDefault();
            event.stopPropagation();
            var $row = $(this).parents("tr");
            var rowIsPopulated = isPopulated($row);
            var $prev = $row.prev();
            var $next = $row.next();
            var nextIsPopulated = isPopulated($next);
            if (
                (!$next.length && rowIsPopulated)
                || (!$prev.length && nextIsPopulated) 
                || (rowIsPopulated && nextIsPopulated)
            ) {
                var $newRow = $row.clone();
                $("input",$newRow).val("");
                $row.after($newRow);
            }
        });
        // removing option
        $(document).on('click', "form.aui.checklist.column.selectlabel .removeoption", function(event) {
            event.preventDefault();
            event.stopPropagation();
            if($(this).parents("tbody").find('.removeoption').length > 1) {
                var $row = $(this).parents("tr");
                $row.remove();
            }
        });
        $(document).on('change', "form.aui.checklist.column.selectlabel input[name='label']", function(event) {
            event.preventDefault();
            var $row = $(this).parents("tr");
            var $caption = $("input[name='caption']",$row);
            if ($caption.val() == "") {
                $caption.val($(this).val());
            }
        });

        $(document).on('blur', "form.aui.checklist.column.selectlabel input[name='caption']", function(event) {
            event.preventDefault();
            var $row = $(this).parents("tr");
            if (! $row.next() || ! $row.next().is("tr")) {
                var $newRow = $row.clone();
                $("input",$newRow).val("");
                $row.after($newRow);
                $("input[name='label']",$newRow).focus();
            }
        });

        // Saving column
        $(document).on('click', "form.aui.checklist.column.selectlabel .accept", function(event) {
            event.preventDefault();
            var $form = $(this).parents("form.aui.checklist");
            var column = $form.getColumnInfo();
            column.setAttributes($form);
            column.resetHeading();
            // let's set the column's specific properties
            var readonly = $("#readonly:checked", $form).val();
            column.column[column.type].readOnly = typeof readonly != 'undefined' ;

            column.column[column.type].options = [];
            var errorCount = 0;
            $("tr",$form).each(function() {
                var option = {};
                var $key = $(this).find("input[name='label']");
                option.key = $key.val();
                option.value = $(this).find("input[name='caption']").val();
                if (option.key && option.key.length > 0) {
                    if (Adhoc.common.isValidLabel(option.key) ){
                        if (option.value == undefined && option.value.length == 0) {
                            option.value = option.key;
                        }
                        column.column[column.type].options.push(option);
                    } else {
                        Adhoc.common.errorMessage($key.parent(), AJS.I18n.getText("adhoclists.boards.designer.error.invalid-label"), 5000);
                        errorCount++;
                    }
                }
            });
            if (column.column[column.type].options.length > 0 &&  errorCount == 0) {
                Adhoc.Checklist.columnDialog.hide();
                Adhoc.Checklist.refresh();
            }
        });
    });
})(AJS.$);