/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.macro;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.adhoclists.boards.BoardCreator;
import com.comalatech.confluence.adhoclists.boards.events.BoardViewEvent;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.storage.BoardManager;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardJsonSerializer;
import com.comalatech.confluence.boards.macro.BoardMacroParameters;
import com.comalatech.confluence.boards.macro.NewConditionalMacro;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.service.BoardExportService;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NewBoardMacro
extends NewConditionalMacro {
    private final String TEMPLATE = "/boards/templates/boards-iframe.vm";
    private final BoardExportService boardExportService;
    private final BoardJsonSerializer boardJsonSerializer;
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final BoardManager boardManager;
    private final BoardCreator boardCreator;
    @ComponentImport
    private final AccessModeService accessModeService;
    @ComponentImport
    private final EventPublisher eventPublisher;
    private final ComalaI18nBean comalaI18nBean;
    @ComponentImport
    private final VelocityHelperService velocityHelperService;

    public NewBoardMacro(RestCondition restCondition, SpaceManager spaceManager, AdhocLicenseManager licenseManager, BoardExportService boardExportService, BoardJsonSerializer boardJsonSerializer, AccessModeService accessModeService, I18nResolver i18nResolver, BoardManager boardManager, BoardCreator boardCreator, EventPublisher eventPublisher, ComalaI18nBean comalaI18nBean, VelocityHelperService velocityHelperService) {
        super(restCondition, spaceManager, licenseManager);
        this.boardExportService = boardExportService;
        this.boardJsonSerializer = boardJsonSerializer;
        this.accessModeService = accessModeService;
        this.i18nResolver = i18nResolver;
        this.boardManager = boardManager;
        this.boardCreator = boardCreator;
        this.eventPublisher = eventPublisher;
        this.comalaI18nBean = comalaI18nBean;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> macroParameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        try {
            PageContext pageContext = conversionContext.getPageContext();
            MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
            MacroId macroId = macroDefinition.getMacroIdentifier().isEmpty() ? MacroId.fromString((String)"") : (MacroId)macroDefinition.getMacroIdentifier().get();
            BoardMacroParameters boardMacroParameters = new BoardMacroParameters(macroId.getId(), macroParameters, body, pageContext);
            if (!boardMacroParameters.preview && StringUtils.isNotBlank((CharSequence)boardMacroParameters.spaceKey)) {
                this.checkDisplayPermission(this, boardMacroParameters.spaceKey, NewConditionalMacro.MacroCondition.SHOWBOARD);
            }
            this.boardExportService.importMarkupCards(boardMacroParameters, pageContext.getEntity());
            if (Arrays.asList(BoardExportService.SUPPORTED_EXPORT_FORMATS).contains(boardMacroParameters.outputType)) {
                return this.boardExportService.renderBoard(boardMacroParameters);
            }
            Map context = MacroUtils.defaultVelocityContext();
            Board board = this.resolveBoard(boardMacroParameters.body, boardMacroParameters);
            board.setFilter(boardMacroParameters.filter);
            context.put("boardMarkup", this.boardJsonSerializer.serialize(board));
            context.put("isReadonlyModeEnabled", this.checkReadonlyStatus());
            context.put("licenseManager", this.getLicenseManager());
            context.put("i18nResolver", this.i18nResolver);
            context.put("pageId", pageContext.getEntity().getId());
            context.put("spaceKey", pageContext.getSpaceKey());
            this.eventPublisher.publish((Object)new BoardViewEvent());
            return this.velocityHelperService.getRenderedTemplate("/boards/templates/boards-iframe.vm", context);
        }
        catch (MacroException e) {
            throw new MacroExecutionException((Throwable)e);
        }
    }

    private Board resolveBoard(String body, BoardMacroParameters boardMacroParameters) throws MacroExecutionException {
        Board board;
        if (StringUtils.isNotBlank((CharSequence)body)) {
            board = (Board)this.boardJsonSerializer.deserialize(body);
            if (board == null) {
                throw new MacroExecutionException("Error parsing board " + boardMacroParameters.name);
            }
        } else {
            board = (Board)this.boardManager.get(boardMacroParameters.spaceKey, boardMacroParameters.name);
            if (board == null) {
                board = (Board)this.boardManager.get(boardMacroParameters.name);
            }
            if (board == null && this.comalaI18nBean.getText("title.labels.popular").equals(boardMacroParameters.name)) {
                board = this.boardCreator.createPopularLabelsBoard(boardMacroParameters.spaceKey);
            }
        }
        if (board == null) {
            throw new MacroExecutionException("board \"" + boardMacroParameters.name + "\" does not exist");
        }
        board = this.boardCreator.resolveUserOnContainerCaption(board);
        return board;
    }

    private boolean checkReadonlyStatus() {
        return this.accessModeService.isReadOnlyAccessModeEnabled() || !this.getLicenseManager().isLicensed() && !this.getLicenseManager().isDevelopmentInstance();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

