/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.utils;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VelocityPageHelper {
    private static final Logger log = LoggerFactory.getLogger(VelocityPageHelper.class);
    private final WikiStyleRenderer wikiStyleRenderer;
    private final XhtmlContent xhtmlContent;

    public VelocityPageHelper(@ComponentImport WikiStyleRenderer wikiStyleRenderer, @ComponentImport XhtmlContent xhtmlContent) {
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.xhtmlContent = xhtmlContent;
    }

    public String renderMarkupHtml(AbstractPage page, String wiki) {
        if (page == null || !StringUtils.isNotBlank((CharSequence)wiki)) {
            return "";
        }
        PageContext pageContext = page.toPageContext();
        pageContext.pushRenderMode(RenderMode.suppress((long)256L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, wiki);
    }

    public String renderMarkupUnescapedHtml(AbstractPage page, String wiki) {
        PageContext pageContext = page.toPageContext();
        pageContext.pushRenderMode(RenderMode.suppress((long)256L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, StringEscapeUtils.unescapeHtml4((String)wiki));
    }

    @HtmlSafe
    public String convertStorageToView(AbstractPage page, String storage) {
        String view = "";
        try {
            DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)page.toPageContext());
            view = this.xhtmlContent.convertStorageToView(storage, (ConversionContext)conversionContext);
        }
        catch (Exception e) {
            log.error("Error parsing macro in storage format to HTML", (Throwable)e);
        }
        return view;
    }

    public WikiStyleRenderer getWikiStyleRenderer() {
        return this.wikiStyleRenderer;
    }
}

