/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.templates;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.editor.EditorConverter;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.pages.templates.variables.StringVariable;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import com.comalatech.confluence.adhoclists.templates.PageTemplateModuleDescriptor;
import com.comalatech.confluence.adhoclists.templates.model.AdhocTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultAdhocTemplateManager
implements AdhocTemplateManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAdhocTemplateManager.class);
    private final PageTemplateManager pageTemplateManager;
    private final PluginAccessor pluginAccessor;
    protected SpaceManager spaceManager;
    private final EditorConverter editorConverter;

    public DefaultAdhocTemplateManager(@ComponentImport PageTemplateManager pageTemplateManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport SpaceManager spaceManager, @Qualifier(value="editorConverter") @ComponentImport EditorConverter editorConverter) {
        this.pageTemplateManager = pageTemplateManager;
        this.pluginAccessor = pluginAccessor;
        this.spaceManager = spaceManager;
        this.editorConverter = editorConverter;
    }

    @Override
    public List<PageTemplate> getPageTemplates(String spaceKey) {
        List<PageTemplate> templates;
        if (spaceKey == null) {
            templates = this.pageTemplateManager.getGlobalPageTemplates();
        } else {
            Space space = this.spaceManager.getSpace(spaceKey);
            templates = this.pageTemplateManager.getPageTemplates(space);
            List globalTemplates = this.pageTemplateManager.getGlobalPageTemplates();
            templates = DefaultAdhocTemplateManager.disjunction(templates, globalTemplates);
        }
        return templates;
    }

    @Override
    public List<String> getPageTemplateNames(String spaceKey) {
        ArrayList<String> names = new ArrayList<String>();
        List<PageTemplate> pageTemplates = this.getPageTemplates(spaceKey);
        pageTemplates.addAll(this.getBundledTemplates());
        for (PageTemplate template : pageTemplates) {
            if (spaceKey != null && template.getSpace() == null) continue;
            names.add(template.getName());
        }
        return names;
    }

    private PageTemplate getBundledTemplate(String name) {
        List<PageTemplate> bundledTemplates = this.getBundledTemplates();
        try {
            return bundledTemplates.stream().filter(input -> input.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new NoSuchElementException("No matching template found"));
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<PageTemplate> getBundledTemplates() {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(PageTemplateModuleDescriptor.class);
        if (descriptors == null) {
            return Collections.EMPTY_LIST;
        }
        return descriptors.stream().map(PageTemplateModuleDescriptor::getModule).collect(Collectors.toList());
    }

    @Override
    public String getTemplateBody(String spaceKey, String templateName) {
        if (!StringUtils.isNotBlank((CharSequence)templateName)) {
            return "";
        }
        PageTemplate template = this.getPageTemplate(spaceKey, templateName);
        if (template == null) {
            log.warn("template '" + templateName + "' does not exist");
            return "";
        }
        return template.getContent();
    }

    @Override
    public PageTemplate getPageTemplate(String spaceKey, String templateName) {
        Space space;
        PageTemplate template = this.pageTemplateManager.getPageTemplate(templateName = templateName == null ? "" : templateName, space = spaceKey != null ? this.spaceManager.getSpace(spaceKey) : null);
        if (template == null && space != null) {
            template = this.pageTemplateManager.getPageTemplate(templateName, null);
        }
        if (template == null) {
            template = this.getBundledTemplate(templateName);
        }
        return template;
    }

    @Override
    public AdhocTemplate getTemplate(String spaceKey, String templateName) {
        PageTemplate template = this.getPageTemplate(spaceKey, templateName);
        if (template == null) {
            return null;
        }
        AdhocTemplate adhocTemplate = new AdhocTemplate(template);
        List variables = null;
        try {
            variables = this.pageTemplateManager.getTemplateVariables(template);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        for (StringVariable variable : variables) {
            adhocTemplate.addVariable(variable.getName());
        }
        return adhocTemplate;
    }

    @Override
    public String mergeTemplateVariables(AdhocTemplate template, String spaceKey) {
        ArrayList<StringVariable> variables = new ArrayList<StringVariable>(template.getVariables().size());
        for (AdhocTemplate.TemplateVariable templateVariable : template.getVariables()) {
            String value = templateVariable.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) {
                value = "";
            }
            variables.add(new StringVariable(templateVariable.getName(), value));
        }
        try {
            PageContext pageContext = new PageContext(spaceKey);
            DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)pageContext);
            String editorMergeResult = this.pageTemplateManager.mergeVariables(template.getPageTemplate(), variables, spaceKey);
            String xhtml = this.editorConverter.convert(editorMergeResult, (ConversionContext)conversionContext);
            return xhtml;
        }
        catch (XhtmlException e) {
            log.error("", (Throwable)e);
            log.warn("Something went wrong merging page templates ... returning with empty hands");
            return "";
        }
    }

    private static List<PageTemplate> disjunction(List<PageTemplate> list1, List<PageTemplate> list2) {
        HashSet<PageTemplate> set1 = new HashSet<PageTemplate>(list1);
        HashSet<PageTemplate> set2 = new HashSet<PageTemplate>(list2);
        HashSet<PageTemplate> result = new HashSet<PageTemplate>(set1);
        result.addAll(set2);
        HashSet<PageTemplate> intersection = new HashSet<PageTemplate>(set1);
        intersection.retainAll(set2);
        result.removeAll(intersection);
        return new ArrayList<PageTemplate>(result);
    }
}

