/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage.serializer;

import com.comalatech.confluence.adhoclists.lists.model.Checklist;
import com.comalatech.confluence.adhoclists.lists.model.Column;
import com.comalatech.confluence.adhoclists.storage.serializer.ChecklistSerializer;
import com.comalatech.confluence.adhoclists.storage.serializer.TableJasonSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChecklistJsonSerializer
extends TableJasonSerializer<Checklist>
implements ChecklistSerializer {
    private static final Logger log = LoggerFactory.getLogger(ChecklistJsonSerializer.class);

    @Override
    protected Class getTableClass() {
        return Checklist.class;
    }

    @Override
    public <T> T deserializeColumn(String table, Class<T> columnType) {
        try {
            return (T)this.mapper.readValue(table, columnType);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public String serializeColumn(Column column) {
        StringWriter writer = new StringWriter();
        try {
            this.mapper.writeValue((Writer)writer, (Object)column);
            return writer.toString();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }
}

