/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.comalatech.confluence.adhoclists.content.ComalaPropertiesSetManager;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.storage.AbstractTableManager;
import com.comalatech.confluence.adhoclists.storage.BoardManager;
import com.comalatech.confluence.adhoclists.storage.BoardModuleDescriptor;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardJsonSerializer;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardXmlSerializer;
import com.comalatech.confluence.adhoclists.storage.serializer.MockBoardSerializer;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.Container;
import com.comalatech.confluence.boards.model.MockBoard;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultBoardManager
extends AbstractTableManager<Board>
implements BoardManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultBoardManager.class);
    private final BoardXmlSerializer boardXmlSerializer;
    private final BoardJsonSerializer boardJsonSerializer;
    private final MockBoardSerializer mockBoardSerializer;
    private final ComalaI18nBean comalaI18nBean;

    public DefaultBoardManager(@ComponentImport BandanaManager bandanaManager, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport PluginAccessor pluginAccessor, ComalaPropertiesSetManager contentPropertyManager, @ComponentImport SearchManager searchManager, @ComponentImport AnyTypeDao anyTypeDao, @ComponentImport PageManager pageManager, @ComponentImport XhtmlContent xhtmlContent, BoardXmlSerializer boardXmlSerializer, BoardJsonSerializer boardJsonSerializer, MockBoardSerializer mockBoardSerializer, ComalaI18nBean comalaI18nBean) {
        super(bandanaManager, transactionTemplate, pluginAccessor, contentPropertyManager, searchManager, anyTypeDao, pageManager, xhtmlContent, comalaI18nBean);
        this.boardXmlSerializer = boardXmlSerializer;
        this.boardJsonSerializer = boardJsonSerializer;
        this.mockBoardSerializer = mockBoardSerializer;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public Board deserialize(String body) {
        try {
            return (Board)this.boardXmlSerializer.deserialize(body);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public String serialize(Board board) {
        return this.boardXmlSerializer.serialize(board);
    }

    @Override
    public Board deserializeJson(String body) {
        try {
            return (Board)this.boardJsonSerializer.deserialize(body);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public String serializeJson(Board template) {
        return this.boardJsonSerializer.serialize(template);
    }

    @Override
    protected String serializeMock(Table mock) {
        return this.mockBoardSerializer.serialize((MockBoard)mock);
    }

    @Override
    protected Table deserializeMock(String mock) {
        return this.mockBoardSerializer.deserialize(mock);
    }

    @Override
    protected Class getDescriptorClass() {
        return BoardModuleDescriptor.class;
    }

    @Override
    public String getBandanaKey() {
        return "adhoclists.templates.boards";
    }

    @Override
    public String getMacroName() {
        return "adhocboard";
    }

    @Override
    public Board makeEmpty() {
        Board board = new Board(this.comalaI18nBean.getText("adhoclists.rte.boards.select.new"), Board.Type.LABEL);
        board.setDescription(this.comalaI18nBean.getText("adhoclists.rte.boards.select.new.description"));
        board.addRow().addColumn().add(new Container());
        return board;
    }

    @Override
    protected String getDefaultNewTableName() {
        return this.comalaI18nBean.getText("adhoclists.rte.boards.select.new");
    }
}

