/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.rest.column;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.metadata.MetadataAccessor;
import com.comalatech.confluence.adhoclists.rest.AbstractChecklistResources;
import com.comalatech.confluence.adhoclists.rest.AbstractRestResources;
import com.comalatech.confluence.adhoclists.rest.PermissionRequired;
import com.comalatech.confluence.adhoclists.storage.serializer.ChecklistJsonSerializer;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import com.comalatech.confluence.adhoclists.utils.PluginContainerManager;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/lists/metadata")
public class MetadataResources
extends AbstractChecklistResources {
    private final MetadataAccessor metadataAccessor;
    private final WikiStyleRenderer wikiStyleRenderer;

    @Inject
    public MetadataResources(@ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PermissionManager permissionManager, @ComponentImport LabelManager labelManager, FilterManager filterManager, AdhocTemplateManager adhocTemplateManager, @ComponentImport PageTemplateManager pageTemplateManager, @ComponentImport I18nResolver i18nResolver, RestCondition restCondition, BoardValidator boardValidator, ChecklistJsonSerializer checklistSerializer, MetadataAccessor metadataAccessor, @ComponentImport WikiStyleRenderer wikiStyleRenderer, @ComponentImport VelocityHelperService velocityHelperService) {
        super(pageManager, spaceManager, permissionManager, labelManager, filterManager, PluginContainerManager.getComponent("pageManager", ContentEntityManager.class), adhocTemplateManager, pageTemplateManager, i18nResolver, restCondition, boardValidator, checklistSerializer, velocityHelperService);
        this.metadataAccessor = metadataAccessor;
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT})
    @POST
    @Path(value="/{pageId}/set")
    @Produces(value={"text/html"})
    @Consumes(value={"application/json"})
    public Response setMetadata(@PathParam(value="pageId") long pageId, final @QueryParam(value="valueName") String valueName, final @QueryParam(value="renderWikiMarkup") boolean render, final String value) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) {
                MetadataResources.this.metadataAccessor.setValue(page, valueName, value);
                String renderedResponse = render ? MetadataResources.this.renderMetadata(page, value) : "";
                return Response.ok((Object)renderedResponse).build();
            }
        }.execute(pageId);
    }

    private String renderMetadata(AbstractPage page, String value) {
        PageContext context = page.toPageContext();
        context.pushRenderMode(RenderMode.suppress((long)256L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, value);
    }
}

