/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.rest;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.rest.AbstractExchangeServices;
import com.comalatech.confluence.adhoclists.rest.model.TableCategory;
import com.comalatech.confluence.adhoclists.rest.model.TableListing;
import com.comalatech.confluence.adhoclists.storage.BoardManager;
import com.comalatech.confluence.adhoclists.storage.TableManager;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardJsonSerializer;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import com.comalatech.confluence.adhoclists.utils.PluginContainerManager;
import com.comalatech.confluence.boards.model.Board;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/exchange/boards")
public class ExchangeBoardResources
extends AbstractExchangeServices<Board> {
    private final WikiStyleRenderer wikiStyleRenderer;

    @Inject
    public ExchangeBoardResources(@ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PermissionManager permissionManager, @ComponentImport LabelManager labelManager, FilterManager filterManager, AdhocTemplateManager adhocTemplateManager, @ComponentImport PageTemplateManager pageTemplateManager, @ComponentImport I18nResolver i18nResolver, RestCondition restCondition, BoardValidator boardValidator, BoardJsonSerializer boardJsonSerializer, BoardManager boardManager, @ComponentImport WikiStyleRenderer wikiStyleRenderer, @ComponentImport VelocityHelperService velocityHelperService) {
        super(pageManager, spaceManager, permissionManager, labelManager, filterManager, PluginContainerManager.getComponent("pageManager", ContentEntityManager.class), adhocTemplateManager, pageTemplateManager, i18nResolver, restCondition, boardValidator, boardJsonSerializer, boardManager, velocityHelperService);
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getCategories(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="blueprint") boolean blueprint) {
        ArrayList<TableCategory> categories = new ArrayList<TableCategory>();
        categories.add(new TableCategory("bundled-table", this.i18nResolver.getText("adhoccanvas.exchange.boards.samples"), this.i18nResolver.getText("adhoccanvas.exchange.boards.samples.description")));
        String i18nKey = this.tableManager.hasTables(spaceKey) ? "adhoccanvas.exchange.boards.search.description" : "adhoccanvas.exchange.boards.search.description.noboards";
        String boardSearchDesc = this.i18nResolver.getText(i18nKey);
        categories.add(new TableCategory("search-table", this.i18nResolver.getText("adhoccanvas.exchange.boards.search"), boardSearchDesc));
        return Response.ok(categories).build();
    }

    @GET
    @Path(value="/{category}")
    @Produces(value={"application/json"})
    public Response getBoards(@PathParam(value="category") String category, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="blueprint") boolean blueprint) {
        List<TableListing> boards = this.getListings(category, spaceKey, !blueprint);
        return Response.ok(boards).build();
    }

    @GET
    @Path(value="/{category}/{spaceKey}/{id}")
    @Produces(value={"application/json"})
    public Response getBoard(@PathParam(value="category") String category, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="id") long id) {
        Board board = (Board)this.getTable(category, spaceKey, id);
        if (board == null) {
            return Response.noContent().build();
        }
        TableListing table = new TableListing(id, board);
        return Response.ok((Object)table).build();
    }

    @GET
    @Path(value="/{category}/{id}")
    @Produces(value={"application/json"})
    public Response getBoard(@PathParam(value="category") String category, @PathParam(value="id") long id) {
        return this.getBoard(category, null, id);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/wiki")
    public Response renderWiki(Map<String, Object> wikiBody) {
        PageContext context = new Page().toPageContext();
        context.pushRenderMode(RenderMode.suppress((long)260L));
        String html = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, (String)wikiBody.get("wiki"));
        return Response.ok((Object)new RenderedWiki(html)).build();
    }

    @Override
    public TableManager.TableDescriptor<Board> makeEmptyTableDescriptor() {
        return new TableManager.TableDescriptor<Board>(0L, this.i18nResolver.getText("adhoccanvas.exchange.boards.empty"));
    }

    @Override
    public TableManager.TableDescriptor<Board> makeImportTableDescriptor() {
        return new TableManager.TableDescriptor<Board>(-1L, this.i18nResolver.getText("adhoccanvas.exchange.boards.import"));
    }

    @XmlRootElement(name="wiki")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RenderedWiki {
        String wikiHtml;

        public RenderedWiki(String wikiHtml) {
            this.wikiHtml = wikiHtml;
        }
    }
}

