/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.model;

import java.awt.Color;

public class StyledColor {
    private static final float BRIGHTER_FACTOR = 1.8f;
    String color;
    String brighter;

    public StyledColor(String color) {
        if (!((String)color).startsWith("#")) {
            color = "#" + (String)color;
        }
        this.color = color;
        Color c = Color.decode((String)color);
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
        this.brighter = this.toString(Color.getHSBColor(hsb[0], hsb[1] * 1.8f, hsb[2]));
    }

    public String getColor() {
        return this.color;
    }

    public String getBrighter() {
        return this.brighter;
    }

    private String toString(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

