/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.metadata;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.HtmlToXmlConverter;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.util.PairType;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import com.comalatech.confluence.adhoclists.metadata.MetadataAccessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class TabularMetadataAccessor
implements MetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(TabularMetadataAccessor.class);
    private static final TabularMetadataAccessor INSTANCE = new TabularMetadataAccessor();
    private XhtmlContent xhtmlContent;
    private HtmlToXmlConverter htmlToXmlConverter;
    public static final String CHARSET_UTF8 = "UTF-8";

    private TabularMetadataAccessor() {
        ContainerManager.autowireComponent((Object)this);
    }

    public static TabularMetadataAccessor getInstance() {
        return INSTANCE;
    }

    @Override
    public String getValue(AbstractPage page, String valueName) {
        ArrayList pairsList = new ArrayList();
        try {
            this.xhtmlContent.handleMacroDefinitions(page.getBodyAsString(), (ConversionContext)new DefaultConversionContext((RenderContext)page.toPageContext()), macroDefinition -> {
                String bodyText;
                if ("details".equals(macroDefinition.getName()) && StringUtils.isNotBlank((CharSequence)(bodyText = macroDefinition.getBodyText()))) {
                    try {
                        pairsList.addAll(this.getDetails(bodyText, (ConversionContext)new DefaultConversionContext((RenderContext)page.toPageContext())));
                    }
                    catch (XhtmlException | IOException | XMLStreamException e) {
                        log.error(e.getMessage());
                    }
                }
            });
        }
        catch (XhtmlException e) {
            log.error(String.format("cannot process page xhtml of %s:%s", page.getSpaceKey(), page.getTitle()));
        }
        List matchingPairs = pairsList.stream().filter(input -> input.getKey().equals(valueName.toLowerCase())).collect(Collectors.toList());
        return !matchingPairs.isEmpty() ? (String)((Object)((PairType)matchingPairs.get(matchingPairs.size() - 1)).getValue()) : "";
    }

    @Override
    public void setValue(AbstractPage page, String valueName, String value) {
        log.error("Tabular Metadata edit not (yet) implemented.");
        throw new RuntimeException("Tabular Metadata edit not (yet) implemented. ");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public void setXhtmlContent(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    public void setHtmlToXmlConverter(HtmlToXmlConverter htmlToXmlConverter) {
        this.htmlToXmlConverter = htmlToXmlConverter;
    }

    private List<PairType> getDetails(String macroBodyXhtml, ConversionContext conversionContext) throws XMLStreamException, XhtmlException, IOException {
        ArrayList<PairType> pairTypes = new ArrayList<PairType>();
        String pageHtml = this.xhtmlContent.convertStorageToView(macroBodyXhtml, conversionContext);
        String xml = this.htmlToXmlConverter.convert(pageHtml);
        String macroBodyXhtmlCleaned = "<div>" + xml + "</div>";
        Document macroBodyDoc = this.getMacroBodyDocument(macroBodyXhtmlCleaned);
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node tableElement = (Node)xpath.evaluate("//tbody", macroBodyDoc, XPathConstants.NODE);
            if (tableElement == null) {
                return pairTypes;
            }
            NodeList rowElements = tableElement.getChildNodes();
            return this.loadDetailPairsFromTableRows(rowElements, pairTypes);
        }
        catch (Exception e) {
            log.error("Error processing the macro body document.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<PairType> loadDetailPairsFromTableRows(NodeList rowElements, List<PairType> pairTypes) throws IOException {
        int i;
        boolean firstRowIsThs = false;
        ArrayList<Element> keyElements = new ArrayList<Element>();
        ArrayList<Element> valueElements = new ArrayList<Element>();
        for (i = 0; i < rowElements.getLength(); ++i) {
            Node rowElem = rowElements.item(i);
            if (rowElem.getNodeType() != 1) continue;
            Element rowElement = (Element)rowElem;
            NodeList tds = rowElement.getElementsByTagName("td");
            NodeList ths = rowElement.getElementsByTagName("th");
            if (tds.getLength() > 0) {
                if (firstRowIsThs) {
                    valueElements.add((Element)tds.item(0));
                    break;
                }
                if (ths.getLength() > 0) {
                    keyElements.add((Element)ths.item(0));
                    valueElements.add((Element)tds.item(0));
                    continue;
                }
                keyElements.add((Element)tds.item(0));
                valueElements.add(tds.getLength() > 1 ? (Element)tds.item(1) : null);
                continue;
            }
            if (ths.getLength() <= 0) continue;
            keyElements = new ArrayList();
            firstRowIsThs = true;
        }
        for (i = 0; i < keyElements.size(); ++i) {
            Element keyElement = (Element)keyElements.get(i);
            Element valueElement = valueElements.size() > i ? (Element)valueElements.get(i) : null;
            pairTypes.add(new PairType((Serializable)((Object)this.getInnerHtml(keyElement).toLowerCase()), (Serializable)((Object)this.getInnerHtml(valueElement))));
        }
        return pairTypes;
    }

    private String getInnerHtml(Element element) {
        if (element == null) {
            return "";
        }
        StringBuilder innerHtml = new StringBuilder();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            innerHtml.append(this.nodeToString(node));
        }
        return innerHtml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getMacroBodyDocument(String macroBodyXhtmlCleaned) {
        byte[] errorStreamContents;
        Document document;
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        Tidy tidy = new Tidy();
        tidy.setQuiet(true);
        tidy.setErrout(new PrintWriter(errorStream));
        tidy.setInputEncoding(CHARSET_UTF8);
        try {
            document = tidy.parseDOM((InputStream)new ByteArrayInputStream(macroBodyXhtmlCleaned.getBytes(StandardCharsets.UTF_8)), null);
        }
        catch (Throwable throwable) {
            byte[] errorStreamContents2;
            if (log.isWarnEnabled() && (errorStreamContents2 = errorStream.toByteArray()).length > 0) {
                log.warn(String.format("There were some warnings parsing the specified HTML fragment\n%s", new String(errorStreamContents2)));
            }
            throw throwable;
        }
        if (log.isWarnEnabled() && (errorStreamContents = errorStream.toByteArray()).length > 0) {
            log.warn(String.format("There were some warnings parsing the specified HTML fragment\n%s", new String(errorStreamContents)));
        }
        return document;
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            log.error("Node transformation error.", (Throwable)te);
        }
        return sw.toString();
    }
}

