/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.metadata;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoclists.boards.events.MetadataKeySentEvent;
import com.comalatech.confluence.adhoclists.metadata.CustomwareMetaDataAccessor;
import com.comalatech.confluence.adhoclists.metadata.MetadataAccessor;
import com.comalatech.confluence.adhoclists.metadata.MetadataManagerAccessor;
import com.comalatech.confluence.adhoclists.metadata.MetadataMetadataAccessor;
import com.comalatech.confluence.adhoclists.metadata.TabularMetadataAccessor;
import com.comalatech.confluence.adhoclists.model.GlobalConfig;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import org.springframework.stereotype.Component;

@Component
public class DefaultMetadataAccessor
implements MetadataAccessor {
    private final GlobalConfigManager globalConfigManager;
    private final EventPublisher eventPublisher;
    private final MetadataManagerAccessor metadataManagerAccessor;
    private MetadataAccessor metadataAccessorDelegate;

    public DefaultMetadataAccessor(GlobalConfigManager globalConfigManager, @ComponentImport EventPublisher eventPublisher, MetadataManagerAccessor metadataManagerAccessor) {
        this.globalConfigManager = globalConfigManager;
        this.eventPublisher = eventPublisher;
        this.metadataManagerAccessor = metadataManagerAccessor;
    }

    @Override
    public String getValue(AbstractPage page, String valueName) {
        return this.getMetadataAccessorDelegate().getValue(page, valueName);
    }

    @Override
    public void setValue(AbstractPage page, String key, String value) {
        this.getMetadataAccessorDelegate().setValue(page, key, value);
    }

    public MetadataAccessor getMetadataAccessorDelegate() {
        GlobalConfig globalConfig = this.globalConfigManager.loadGlobalConfig();
        if (globalConfig.getMetadataAccessorType() != GlobalConfig.MetadataAccessorType.Default) {
            this.eventPublisher.publish((Object)new MetadataKeySentEvent());
        }
        if (this.metadataAccessorDelegate != null) {
            return this.metadataAccessorDelegate;
        }
        if (globalConfig.getMetadataAccessorType() == GlobalConfig.MetadataAccessorType.Scaffold) {
            this.metadataAccessorDelegate = new CustomwareMetaDataAccessor(this.metadataManagerAccessor);
            return this.metadataAccessorDelegate;
        }
        if (globalConfig.getMetadataAccessorType() == GlobalConfig.MetadataAccessorType.Tabular) {
            this.metadataAccessorDelegate = TabularMetadataAccessor.getInstance();
            return this.metadataAccessorDelegate;
        }
        this.metadataAccessorDelegate = MetadataMetadataAccessor.getInstance();
        return this.metadataAccessorDelegate;
    }

    @Override
    public boolean isReadOnly() {
        return this.metadataAccessorDelegate.isReadOnly();
    }

    public void setMetadataAccessorDelegate(MetadataAccessor metadataAccessorDelegate) {
        this.metadataAccessorDelegate = metadataAccessorDelegate;
    }
}

